/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <string.h>
#include "common.h"

#define OLD_MAX_TIME_CLASSES            4
#define OLD_FLG_PRIORITY                0xe000
#define OLD_FLG_SMARTTIME               0x1000
#define OLD_FLG_SSMARTTIME              0x0800
#define OLD_FLG_TCSMARTTIME             0x0400
#define	OLD_FLG_SMARTBOOT               0x0200
#define OLD_FLG_SSMARTBOOT              0x0100
#define OLD_FLG_TCSMARTBOOT             0x0080
#define OLD_FLG_IBOOT                   0x0040
#define OLD_FLG_ISMARTBOOT              0x0020
#define OLD_FLG_EXPIRE                  0x0010
#define OLD_FLG_WARNEXPIRE              0x0008
#define OLD_FLG_ONLINE                  0x0001
#define OLD_PRIORITY(f)                 (((f) & OLD_FLG_PRIORITY) >> 13)
#define OLD_SMARTTIME(f)                ((f) & OLD_FLG_SMARTTIME)
#define OLD_SSMARTTIME(f)               ((f) & OLD_FLG_SSMARTTIME)
#define OLD_TCSMARTTIME(f)              ((f) & OLD_FLG_TCSMARTTIME)
#define OLD_SMARTBOOT(f)                ((f) & OLD_FLG_SMARTBOOT)
#define	OLD_SSMARTBOOT(f)               ((f) & OLD_FLG_SSMARTBOOT)
#define OLD_IBOOT(f)                    ((f) & OLD_FLG_IBOOT)
#define OLD_ISMARTBOOT(f)               ((f) & OLD_FLG_ISMARTBOOT)
#define OLD_TCSMARTBOOT(f)              ((f) & OLD_FLG_TCSMARTBOOT)
#define OLD_EXPIRE(f)                   ((f) & OLD_FLG_EXPIRE)
#define OLD_WARNEXPIRE(f)               ((f) & OLD_FLG_WARNEXPIRE)
#define OLD_EXPIRE_DELETE               0x0000
#define OLD_EXPIRE_UNSUBSCRIBE          0x0010

typedef struct {
  short         uid                             __attribute__((packed));
  word          flags                           __attribute__((packed));
  word          phNoArea                        __attribute__((packed));
  word          phNoLocal                       __attribute__((packed));
  int           tLeft                           __attribute__((packed));
  int           tLimit                          __attribute__((packed));
  int           credit                          __attribute__((packed));
  int           sLeft                           __attribute__((packed));
  int           sLimit                          __attribute__((packed));
  short         cLeft[OLD_MAX_TIME_CLASSES]     __attribute__((packed));
  short         cLimit[OLD_MAX_TIME_CLASSES]    __attribute__((packed));
  dword         bTx                             __attribute__((packed));
  dword         bRx                             __attribute__((packed));
  dword         bTxLimit                        __attribute__((packed));
  dword         bRxLimit                        __attribute__((packed));
  dword         bLimit                          __attribute__((packed));
  dword         bStx                            __attribute__((packed));
  dword         bSrx                            __attribute__((packed));
  dword         bStxLimit                       __attribute__((packed));
  dword         bSrxLimit                       __attribute__((packed));
  dword         bSlimit                         __attribute__((packed));
  time_t        subExpire                       __attribute__((packed));
  word          subFlags                        __attribute__((packed));
  int           subTlimit                       __attribute__((packed));
  int           subCredit                       __attribute__((packed));
  int           subSlimit                       __attribute__((packed));
  short         subClimit[OLD_MAX_TIME_CLASSES] __attribute__((packed));
  dword         subBtxLimit                     __attribute__((packed));
  dword         subBrxLimit                     __attribute__((packed));
  dword         subBlimit                       __attribute__((packed));
  dword         subBStxLimit                    __attribute__((packed));
  dword         subBSrxLimit                    __attribute__((packed));
  dword         subBSlimit                      __attribute__((packed));
  time_t        expire                          __attribute__((packed));
  time_t        lastLogin                       __attribute__((packed));
  time_t        lastOnline                      __attribute__((packed));
  word          loginHost                       __attribute__((packed));
} OldUserRec;   // sizeof(OldUserRec) = 222

int
main(int argc, char **argv)
{
  int           i;
  FILE         *inFile, *outFile;
  OldUserRec    our;
  UserRec       ur;

  i = sizeof(OldUserRec);

  if (argc < 3)
    errQuit("acua117-200 <source> <dest>");

  inFile = fopen(argv[1], "rb");
  if (!inFile)
    perrQuit("fopen(%s)", argv[1]);
  outFile = fopen(argv[2], "wb");
  if (!outFile)
    perrQuit("fopen(%s)", argv[2]);

  readConfig();

  // write the magic
  fwrite(ACUA_USERS_MAGIC, 1, ACUA_USERS_MAGIC_LEN, outFile);

  // convert the user records
  while (fread(&our, sizeof(OldUserRec), 1, inFile)) {
    bzero(&ur, sizeof(ur));
    ur.uid = our.uid;
    ur.flags |= our.flags & 0xffff0000;
    ur.flags |= OLD_PRIORITY(our.flags) << 13;
    if (OLD_SMARTTIME(our.flags))
      ur.flags |= FLG_SMARTTIME;
    if (OLD_SSMARTTIME(our.flags))
      ur.flags |= FLG_SSMARTTIME;
    if (OLD_SMARTTIME(our.flags))
      ur.flags |= FLG_SMARTTIME;
    if (OLD_TCSMARTTIME(our.flags))
      ur.flags |= FLG_TCSMARTTIME;
    if (OLD_SMARTBOOT(our.flags))
      ur.flags |= FLG_SMARTBOOT;
    if (OLD_SSMARTBOOT(our.flags))
      ur.flags |= FLG_SSMARTBOOT;
    if (OLD_TCSMARTBOOT(our.flags))
      ur.flags |= FLG_TCSMARTBOOT;
    if (OLD_ISMARTBOOT(our.flags))
      ur.flags |= FLG_ISMARTBOOT;
    if (OLD_EXPIRE(our.flags))
      ur.flags |= FLG_EXPIRE;
    if (OLD_WARNEXPIRE(our.flags))
      ur.flags |= FLG_WARNEXPIRE;
    ur.phNoArea = our.phNoArea;
    ur.phNoLocal = our.phNoLocal;
    ur.lastLogin[MAX_HOSTS - 1] = our.lastLogin;
    ur.lastOnline[MAX_HOSTS - 1] = our.lastOnline;
    ur.maxLogins = ur.maxDeduct = 1;
    ur.idleLimit = optIdleLimit;
    ur.PPPidleMinutes = optPPPidleMinutes;
    ur.PPPidleBytes = optPPPidleBytes;
    ur.tLeft = our.tLeft;
    ur.tLimit = our.tLimit;
    ur.credit = our.credit;
    ur.sLeft = our.sLeft;
    ur.sLimit = our.sLimit;
    for (i = 0; i < 4; i++) {
      ur.cLeft[i] = our.cLeft[i];
      ur.cLimit[i] = our.cLimit[i];
    }
    for (i = 5; i < MAX_TIME_CLASSES; i++) {
      ur.cLeft[i] = 0;
      ur.cLimit[i] = -1;
    }
    ur.bTx = our.bTx;
    ur.bRx = our.bRx;
    ur.bTxLimit = our.bTxLimit;
    ur.bRxLimit = our.bRxLimit;
    ur.bLimit = our.bLimit;
    ur.bStx = our.bStx;
    ur.bSrx = our.bSrx;
    ur.bStxLimit = our.bStxLimit;
    ur.bSrxLimit = our.bSrxLimit;
    ur.subExpire = our.subExpire;
    ur.subFlags |= our.subFlags & 0xffff0000;
    ur.subFlags |= OLD_PRIORITY(our.subFlags) << 13;
    if (OLD_SMARTTIME(our.subFlags))
      ur.subFlags |= FLG_SMARTTIME;
    if (OLD_SSMARTTIME(our.subFlags))
      ur.subFlags |= FLG_SSMARTTIME;
    if (OLD_SMARTTIME(our.subFlags))
      ur.subFlags |= FLG_SMARTTIME;
    if (OLD_TCSMARTTIME(our.subFlags))
      ur.subFlags |= FLG_TCSMARTTIME;
    if (OLD_SMARTBOOT(our.subFlags))
      ur.subFlags |= FLG_SMARTBOOT;
    if (OLD_SSMARTBOOT(our.subFlags))
      ur.subFlags |= FLG_SSMARTBOOT;
    if (OLD_TCSMARTBOOT(our.subFlags))
      ur.subFlags |= FLG_TCSMARTBOOT;
    if (OLD_ISMARTBOOT(our.subFlags))
      ur.subFlags |= FLG_ISMARTBOOT;
    if (OLD_EXPIRE(our.subFlags))
      ur.subFlags |= FLG_EXPIRE;
    if (OLD_WARNEXPIRE(our.subFlags))
      ur.subFlags |= FLG_WARNEXPIRE;
    ur.subMaxLogins = ur.subMaxDeduct = 1;
    ur.subIdleLimit = ur.idleLimit;
    ur.subPPPidleMinutes = ur.PPPidleMinutes;
    ur.subPPPidleBytes = ur.PPPidleBytes;
    ur.subTlimit = our.subTlimit;
    ur.subCredit = our.subCredit;
    ur.subSlimit = our.subSlimit;
    for (i = 0; i < 4; i++)
      ur.subClimit[i] = our.subClimit[i];
    for (i = 5; i < MAX_TIME_CLASSES; i++)
      ur.subClimit[i] = -1;
    ur.subBtxLimit = our.subBtxLimit;
    ur.subBrxLimit = our.subBrxLimit;
    ur.subBlimit = our.subBlimit;
    ur.subBStxLimit = our.subBStxLimit;
    ur.subBSlimit = our.subBSlimit;
    ur.expire = our.expire;

    fwrite(&ur, sizeof(UserRec), 1, outFile);
  }

  fclose(inFile);
  fclose(outFile);
  return 0;
}
