/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <ctype.h>
#include <string.h>
#include "common.h"

static int               userFileSearchPhNo(word phNoArea, word phNoLocal);

int
acua_addRec(int argc, char **argv)
{
  uid_t                    uid;
  BanRec                   br;
  UserRec                  ur,
                           ur2;
  char                     phNo[32];
  int                      i;

  readConfig();
  bzero(&ur, sizeof(UserRec));
  if (argc < 4)
    errQuit("\
usage: addrec <login> <expire> <time_limit> [session_limit] [priority]\n\
              [phone_no] {class_limit}");
  if (argc >= 7) {
    strcpy(phNo, argv[6]);
    if (atoi(phNo) >= 0) {
      if (phNo2Words(&ur.phNoArea, &ur.phNoLocal, phNo, optPhNoDigits) || (ur.phNoArea && !ur.phNoLocal))
        errQuit("invalid phone number: %s", phNo);
      userFileOpen();
      if (!userFileSearchPhNo(ur.phNoArea, ur.phNoLocal))
        errQuit("phone number is already in use: %s", phNo);
      userFileClose();
      banFileOpen();
      if (!banFileSearch(&br, ur.phNoArea, ur.phNoLocal))
        errQuit("phone number is banned: %s", phNo);
      banFileClose();
    }
  }
  if (isdigit(argv[1][0])) uid = atoi(argv[1]);
  else {
    uid = UIDfromLogin(argv[1]);
    if (uid == (uid_t) - 1)
      errQuit("user does not exist: %s", argv[1]);
  }
  userFileOpen();
  if (!userFileSearch(&ur2, uid))
    errQuit("user already exists: %s", argv[1]);
  ur.uid = uid;
  ur.flags = argc >= 6 ? atoi(argv[5]) << 13 : 4 << 13;
  if (optSmartTime)
    ur.flags |= FLG_SMARTTIME;
  if (optSessionSmartTime)
    ur.flags |= FLG_SSMARTTIME;
  if (optTimeClassSmartTime)
    ur.flags |= FLG_TCSMARTTIME;
  if (optSmartBoot)
    ur.flags |= FLG_SMARTBOOT;
  if (optSessionSmartBoot)
    ur.flags |= FLG_SSMARTBOOT;
  if (optTimeClassSmartBoot)
    ur.flags |= FLG_TCSMARTBOOT;
  if (optIdleSmartBoot)
    ur.flags |= FLG_ISMARTBOOT;
  if (nBootWarnTimes || optPPPWarnBoot)
    ur.flags |= FLG_WARNBOOT;
  if (optExplainBoot)
    ur.flags |= FLG_EXPLAINBOOT;
  ur.creation = time(NULL);
  ur.expire = addTime(time(NULL), argv[2]);
  ur.lastLogin[MAX_HOSTS - 1] = time(NULL);
  ur.lastOnline[MAX_HOSTS - 1] = time(NULL);
  ur.maxLogins = ur.maxDeduct = 1;
  ur.idleLimit = optIdleLimit;
  ur.PPPidleMinutes = optPPPidleMinutes;
  ur.PPPidleBytes = optPPPidleBytes;
  ur.tLimit = ur.tLeft = atoi(argv[3]);
  ur.sLimit = ur.sLeft = argc >= 5 ? atoi(argv[4]) : ur.tLimit;
  if (ur.tLimit >= 0 && ur.sLimit > ur.tLimit)
    errQuit("invalid session_limit: %d", ur.sLimit);
  for (i = 0; i < MAX_TIME_CLASSES; i++) {
    ur.cLeft[i] = 0;
    ur.cLimit[i] = -1;
  }
  for (i = 7; i < min(7 + MAX_TIME_CLASSES, argc); i++)
    ur.cLeft[i - 7] = ur.cLimit[i - 7] = atoi(argv[i]);
  fseek(userFile, 0, SEEK_END);
  userFileWrite(&ur);
  userFileClose();
  printf("user added: %s\n", argv[1]);
  return 0;
}

int
userFileSearchPhNo(word phNoArea, word phNoLocal)
{
  UserRec                  ur;

  userFileRewind();
  while (!userFileRead(&ur))
    if (ur.phNoArea == phNoArea && ur.phNoLocal == phNoLocal)
      return 0;
  return 1;
}
