/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include "common.h"

int
acua_daysLeft(int argc, char **argv)
{
  int                      expire = 0;
  uid_t                    uid;
  UserRec                  ur;

  argc = argc; argv = argv;
  readConfig();
  uid = geteuid();
  userFileOpen();
  if (!userFileSearch(&ur, uid)) {
    if (ur.expire) {
      expire = 1;
      printf("%.2f day(s) remaining.\n",
       (float) (ur.expire - time(NULL)) / (24 * 60 * 60));
    }
  }
  userFileClose();
  if (!expire)
    printf("no expiration date!\n");
  return 0;
}
