/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <time.h>
#include <syslog.h>
#include "common.h"

static int               userExpire();
static int               banExpire();

int
acua_expire(int argc, char **argv)
{
  argc = argc; argv = argv;
  readConfig();
  while (!userExpire());
  while (!banExpire());
  return(0);
}

int
userExpire()
{
  time_t                   t;
  char                     login[9];
  UserRec                  ur;
  int			   delete_root;

  delete_root = 0;

  openlog("acua_expire", LOG_PID, LOG_DAEMON);
  userFileOpen();
  time(&t);
  while (!userFileRead(&ur)) {
    if (ur.expire && t >= ur.expire) {
      if (!loginFromUID(login, ur.uid)) continue;
      if (strcmp("root", login) == 0) {
        if (delete_root == 0) {
    	    delete_root = 1;
	    syslog(LOG_CRIT, "%s", "Attempted to delete the root user!");
    	    continue;
	} else {
	    continue;
	}
      }
      userFileClose();
      if (EXPIRE(ur.flags) == EXPIRE_DELETE) {
        runCommand(BIN"/acua", "delUser", login, NULL);
      } else {
        if (ur.flags & FLG_NOUNSUB) {
          // run external script for user if he/she has NOUNSUB set
          runCommand(SBIN"/acua_nounsub", login, NULL);
        } else {
        runCommand(BIN"/acua", "unSubscribe", login, NULL);
        }
      }
      closelog();
      return(0);
    }
  }
  userFileClose();
  closelog();
  return(1);
}

int
banExpire()
{
  time_t                   t;
  BanRec                   br;
  char                     phNo[32];

  banFileOpen();
  time(&t);
  while (!banFileRead(&br)) {
    if (br.expire && t >= br.expire) {
      banFileClose();
      runCommand(BIN"/acua", "unBan", words2PhNo(phNo, br.phNoArea, br.phNoLocal), NULL);
      return(0);
    }
  }
  banFileClose();
  return(1);
}
