/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <ctype.h>
#include <sys/wait.h>
#include "common.h"

static int               purgeUser(int days);

int
acua_purge(int argc, char **argv)
{
  int                      days;

  readConfig();
  if (argc != 2)
    errQuit("usage: purge <days>");
  days = atoi(argv[1]);
  if (days < 14)
    errQuit("<days> must be >= 14.");
  while (!purgeUser(days));
  return(0);
}

int
purgeUser(int days)
{
  time_t                   t;
  char                     login[9];
  UserRec                  ur;

  userFileOpen();
  time(&t);
  while (!userFileRead(&ur)) {
    time_t lastOnlineTime = lastOnline(&ur);
    if ((t - lastOnlineTime) / (24 * 60 * 60) >= days) {
      if (!loginFromUID(login, ur.uid)) continue;
      userFileClose();
      runCommand(SBIN"/acua_deluser", login, NULL);
      return(0);
    }
  }
  userFileClose();
  return(1);
}
