/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include "common.h"

static int               flagsExcluded(word flags);

static int               nProhibited = 0;
static int               prohibited[16];
static int               nRequired = 0;
static int               required[16];

int
acua_renew(int argc, char **argv)
{
  int                      i,
                           optClassRenew = 0,
                           optDataRenew = 0,
                           optTimeRenew = 0;
  UserRec                  ur;

  readConfig();
  while ((i = getopt(argc, argv, "cdptr")) != EOF) {
    switch (i) {
    case 'c': optClassRenew = 1; break;
    case 'd': optDataRenew = 1; break;
    case 'p': prohibited[nProhibited++] = atoi(argv[optind++]); break;
    case 't': optTimeRenew = 1; break;
    case 'r': required[nRequired++] = atoi(argv[optind++]); break;
    }
  }
  if (!optClassRenew && !optDataRenew && !optTimeRenew)
    optClassRenew = optDataRenew = optTimeRenew = 1;
  userFileOpen();
  while (!userFileRead(&ur)) {
    int                      i;

    if (flagsExcluded(ur.flags)) continue;
    if (optTimeRenew) {
      ur.tLeft = ur.tLimit;
      ur.sLeft = ur.sLimit;
    }
    if (optClassRenew)
      for (i = 0; i < MAX_TIME_CLASSES; i++)
        ur.cLeft[i] = ur.cLimit[i];
    if (optDataRenew) {
      ur.bTx = ur.bRx = 0;
      ur.bStx = ur.bSrx = 0;
    }
    userFileEdit(&ur);
  }
  userFileClose();
  return 0;
}

int
flagsExcluded(word flags) {
  int                      i;
  word                     mask;

  for (i = 0; i < nProhibited; i++) {
    mask = 0x00010000 << prohibited[i];
    if (flags & mask) return 1;
  }
  for (i = 0; i < nRequired; i++) {
    mask = 0x00010000 << required[i];
    if (!(flags & mask)) return 1;
  }
  return 0;
}
