#include <assert.h>
#include <pwd.h>
#include <sys/stat.h>
#include "common.h"

static int    search(uid_t uid, FILE * f);

int
acua_sync(int argc, char **argv)
{
  UserRec                  ur;
  char                     tUserPath[16];
  FILE                    *tUserFile;
  
  argc = argc; argv = argv;
  strcpy(tUserPath, "/tmp/XXXXXX");
  mktemp(tUserPath);
  readConfig();
  userFileOpen();
  tUserFile = fopen(tUserPath, "w+b");
  assert(tUserFile != NULL);
  fwrite(ACUA_USERS_MAGIC, 1, ACUA_USERS_MAGIC_LEN, tUserFile);
  while (!userFileRead(&ur))
    if (getpwuid(ur.uid) && search(ur.uid, tUserFile)) {
      fseek(tUserFile, 0, SEEK_END);
      fwrite(&ur, sizeof(UserRec), 1, tUserFile);
    }
  fclose(tUserFile);
  runCommand("/bin/mv", "-f", tUserPath, userFilePath, NULL);
  chmod(userFilePath, 0644);
  userFileClose();
  return 0;
}

int
search(uid_t uid, FILE * f)
{
  int                      res = 1;
  UserRec                  ur;
  char                     magic[ACUA_USERS_MAGIC_LEN];

  rewind(f);
  fread(magic, 1, ACUA_USERS_MAGIC_LEN, f);
  while (fread(&ur, sizeof(UserRec), 1, f)) {
    if (ur.uid == uid) {
      res = 0;
      break;
    }
  }
  return res;
}
