/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <pwd.h>
#include <string.h>
#include <sys/stat.h>
#include <syslog.h>
#include "common.h"

int
acua_unBan(int argc, char **argv)
{
  int                      i,
                           n;
  BanRec                   br;
  char                    *tBanPath,
                          *phNo;
  FILE                    *tBanFile;

  readConfig();
  if (argc < 2)
    errQuit("usage: unBan <phone_no>");
  n = strlen(argv[1]);
  for (i = 2; argv[i]; i++) {
    n = n + strlen(argv[i]) + 1;
  }
  phNo = (char *) malloc(n);
  strcpy(phNo, argv[1]);
  for (i = 2; argv[i]; i++) {
    strcat(phNo, " ");
    strcat(phNo, argv[i]);
  }
  if (phNo2Words(&br.phNoArea, &br.phNoLocal, phNo, optPhNoDigits)) {
    errQuit("invalid phone number: %s", phNo);
  }
  // create a tempory file
  tBanPath = (char *) malloc(strlen(LIB"/acua_tmp.XXXXXX")+1);
  strcpy(tBanPath, LIB"/acua_tmp.XXXXXX");
  if (!mktemp(tBanPath)) {
    // couldn't make the tempory file.
    free(phNo);
    free(tBanPath);
    syslog(LOG_ERR, "Could not create tempory file in [%s].", LIB);
    return(1);
  }
  banFileOpen();
  if (banFileSearch(&br, br.phNoArea, br.phNoLocal)) {
    banFileClose();
    printf("phone number not found: %s\n", phNo);
    unlink(tBanPath);
    free(tBanPath);
    free(phNo);
    return(1);
  }
  tBanFile = fopen(tBanPath, "wb");
  assert(tBanFile != NULL);
  n = ftell(banFile) / sizeof(BanRec) - 1;
  rewind(banFile);
  for (i = 0;; i++) {
    if (banFileRead(&br))
      break;
    if (i == n)
      continue;
    fwrite(&br, sizeof(BanRec), 1, tBanFile);
  }
  banFileClose();
  if (fclose(tBanFile)) {
    // error writing to our tempory file.
    perror("fclose");
    unlink(tBanPath);
    free(phNo);
    free(tBanPath);
    syslog(LOG_ERR, "file i/o error occoured, disk/permission problem?");
    printf("file i/o error occoured, disk/permission problem?\n");
    return(1);
  }
  if (rename(tBanPath, banFilePath)) {
    // error moving the new database over the old one.
    unlink(tBanPath);
    free(phNo);
    free(tBanPath);
    syslog(LOG_ERR, "could not replace ban file, disk/permission problem?");
    printf("could not replace ban file, disk/permission problem?");
    return(1);
  }
  chmod(banFilePath, 0644);
  printf("phone number unbanned: %s\n", phNo);
  free(phNo);
  free(tBanPath);
  return(0);
}
