/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include "common.h"

int
acua_unSubscribe(int argc, char **argv)
{
  int                      i;
  uid_t                    uid;
  UserRec                  ur;

  readConfig();
  if (argc != 2)
    errQuit("usage: unsubscribe <login>");
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t) - 1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (EXPIRE(ur.flags) != EXPIRE_UNSUBSCRIBE)
    errQuit("user does not have a subscription: %s", argv[1]);
  time(&ur.subscrDate);
  ur.flags = ur.subFlags;
  ur.maxLogins = ur.subMaxLogins;
  ur.maxDeduct = ur.subMaxDeduct;
  ur.idleLimit = ur.subIdleLimit;
  ur.PPPidleMinutes = ur.subPPPidleMinutes;
  ur.PPPidleBytes = ur.subPPPidleBytes;
  ur.expire = ur.subExpire;
  ur.tLimit = ur.tLeft = ur.subTlimit;
  ur.credit = ur.subCredit;
  ur.sLimit = ur.sLeft = ur.subSlimit;
  for (i = 0; i < MAX_TIME_CLASSES; i++) {
    ur.cLeft[i] = ur.cLimit[i] = ur.subClimit[i];
    if (ur.cLimit[i] == -1) ur.cLeft[i] = 0;
  }
  ur.bTxLimit = ur.subBtxLimit;
  ur.bRxLimit = ur.subBrxLimit;
  ur.bLimit = ur.subBlimit;
  ur.bStxLimit = ur.subBStxLimit;
  ur.bSrxLimit = ur.subBSrxLimit;
  ur.bSlimit = ur.subBSlimit;
  userFileEdit(&ur);
  userFileClose();
  printf("user unsubscribed: %s\n", argv[1]);
  return 0;
}
