/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <string.h>
#include "common.h"

int
main(int argc, char **argv)
{
  FILE         *inFile, *outFile;
  UserRec       ur;
  byte          inRec[881];
  char          magic[ACUA_USERS_MAGIC_LEN];

  if (argc < 3)
    errQuit("acua200-202 <source> <dest>");

  inFile = fopen(argv[1], "rb");
  if (!inFile)
    perrQuit("fopen(%s)", argv[1]);
  outFile = fopen(argv[2], "wb");
  if (!outFile)
    perrQuit("fopen(%s)", argv[2]);

  readConfig();

  // read the magic
  fread(magic, 1, ACUA_USERS_MAGIC_LEN, inFile);
  if (strcmp(magic, "ACUA200")) {
    errQuit("Magic # check failed for input file");
  }

  // write the magic
  fwrite(ACUA_USERS_MAGIC, 1, ACUA_USERS_MAGIC_LEN, outFile);

  // convert the user records
  while (fread(inRec, 881, 1, inFile)) {
    word firstSegLen = (byte*)&ur.lockDate - (byte*)&ur;
    word secSegLen = 881 - firstSegLen;
    bzero(&ur, sizeof(ur));
    memcpy((byte*)&ur, inRec, firstSegLen);
    memcpy((byte*)&ur + firstSegLen + 4, inRec + firstSegLen, secSegLen);
    fwrite(&ur, sizeof(UserRec), 1, outFile);
  }

  fclose(inFile);
  fclose(outFile);
  return 0;
}
