/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>

/* This program should NEVER use common.h as it
 * will break, for instance when the UserRec struct
 * changes and we use it in here.  So instead we define
 * the stuff we need to know in order to convert the
 * userbase below.
 */
#define OLD_ACUA_USERS_MAGIC		"ACUA202"
#define OLD_ACUA_USERS_MAGIC_LEN	8
#define OLD_ACUA_USERS_REC_LEN		885

#define NEW_ACUA_USERS_MAGIC		"ACUA304"
#define NEW_ACUA_USERS_MAGIC_LEN	8
#define NEW_ACUA_USERS_REC_LEN		1305

int
main(int argc, char **argv)
{
    FILE         *inFile, *outFile;
    char          inRec[OLD_ACUA_USERS_REC_LEN];
    char      	  outRec[NEW_ACUA_USERS_REC_LEN];
    char          magic[OLD_ACUA_USERS_MAGIC_LEN];

    if (argc != 3)
    {
	printf("acua202-304 <source> <dest>\n");
	return(1);
    }

    inFile = fopen(argv[1], "rb");
    if (!inFile)
    {
	printf("error opening %s: ", argv[1]);
	fflush(NULL);  /* this is needed otherwise the output is screwed up */
	perror("fopen");
	return(1);
    }

    /* Read the magic.  Also, we do this here as there is no point opening
     * the output file if the magic check fails.
     */
    fread(magic, 1, OLD_ACUA_USERS_MAGIC_LEN, inFile);
    if (strcmp(magic, OLD_ACUA_USERS_MAGIC))
    {
	printf("Magic # check failed for input file.\n");
	return(1);
    }

    outFile = fopen(argv[2], "wb");
    if (!outFile)
    {
	printf("error opening %s: ", argv[2]);
	fflush(NULL);  /* this is needed otherwise the output is screwed up */
	perror("fopen");
	return(1);
    }

    /* Write the magic */
    fwrite(NEW_ACUA_USERS_MAGIC, 1, NEW_ACUA_USERS_MAGIC_LEN, outFile);

    /* Convert the user records */
    while (fread(inRec, OLD_ACUA_USERS_REC_LEN, 1, inFile))
    {
	memset(&outRec, 0, NEW_ACUA_USERS_REC_LEN);
	memcpy(&outRec, inRec, OLD_ACUA_USERS_REC_LEN);
	fwrite(&outRec, NEW_ACUA_USERS_REC_LEN, 1, outFile);
    }

    fclose(inFile);
    fclose(outFile);
    return(0);
}
