/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2001  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <ctype.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>
#include "common.h"

static void              listBans();

int
acua_ban(int argc, char **argv)
{
    int                      i;
    uid_t                    uid;
    UserRec                  ur;
    BanRec                   br,
			     br2;
    char                     phNo[32] = "";

    readConfig();
    br.flags = 0;
    while ((i = getopt(argc, argv, "lp")) != EOF)
	switch (i) {
	case 'l':
	    listBans();
	    return 0;
	case 'p':
	    br.flags = 1;
	}
    if (getuid())
	errQuit("You must be logged in as root to add bans.");

    if (optind + 1 >= argc)
	errQuit("usage: ban [-l] [-p] <expire> <login>|<phone_no>");

    br.expire = addTime(time(NULL), argv[optind++]);
    if (isdigit(argv[optind][0]) || argv[optind][0] == '(') {
	strcpy(phNo, argv[optind]);
	for (i = optind + 1; i < argc; i++) {
	    strcat(phNo, " ");
	    strcat(phNo, argv[i]);
	}
	if (phNo2Words(&br.phNoArea, &br.phNoLocal, phNo, optPhNoDigits) ||
	    (!br.flags && br.phNoArea && !br.phNoLocal))
	    errQuit("invalid phone number: %s", phNo);
    } else {
	uid = UIDfromLogin(argv[optind]);
	if (uid == (uid_t) - 1)
	    errQuit("user does not exist: %s", argv[optind]);
	userFileOpen();
	if (userFileSearch(&ur, uid))
	    errQuit("user not found: %s", argv[optind]);
	userFileClose();
	runCommand(SBIN"/acua_deluser", argv[optind], NULL);
	if ((!ur.phNoArea) && (!ur.phNoLocal)) {
	    // this user doesn't have a phone number to ban!
	    errQuit("user does not have a phone number entry: %s", argv[optind]);
	}
	br.phNoArea = ur.phNoArea;
	br.phNoLocal = ur.phNoLocal;
    }
    banFileOpen();
    if (!banFileSearch(&br2, br.phNoArea, br.phNoLocal))
	errQuit("phone number is already banned: %s", phNo);
    fseek(banFile, 0, SEEK_END);
    banFileWrite(&br);
    banFileClose();
    if (phNo[0] != '\0') {
	printf("phone number banned: %s", phNo);
	if (br.flags)
	    printf(" (prefix ban)");
	printf("\n");
    } else
	printf("user banned: %s\n", argv[optind]);
    return 0;
}

void
listBans()
{
    char                     str[256],
    str2[256];
    BanRec                   br;

    if (getuid())
	errQuit("You must be logged in as root to list bans.");

    printf("  Type          Phone No.               Expiry\n"
	   "------------------------------------------------------------------\n");
    banFileOpen();
    while (!banFileRead(&br)) {
	if (br.expire) {
	    strcpy(str, ctime(&br.expire));
	    str[strlen(str) - 1] = '\0';
	} else
	    strcpy(str, "N/A");
	printf("  %-14s%-24s%s\n", br.flags ? "PREFIX" : "NORMAL", words2PhNo(str2, br.phNoArea, br.phNoLocal), str);
    }
    banFileClose();
}
