/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <string.h>
#include "common.h"

static void              dumpUser(UserRec * ur);

int
acua_dump(int argc, char **argv)
{
  UserRec                  ur;

  readConfig();
  userFileOpen();
  if (argc > 1) {
    int                      i;

    for (i = 1; i < argc; i++) {
      uid_t                    uid = UIDfromLogin(argv[i]);

      if (uid != (uid_t) - 1 && !userFileSearch(&ur, uid))
        dumpUser(&ur);
    }
  } else {
    while (!userFileRead(&ur)) {
      dumpUser(&ur);
    }
  }
  userFileClose();
  return 0;
}

void
dumpUser(UserRec * ur)
{
  char                     str[256];

  if (!loginFromUID(str, ur->uid))
    return;
  printf("%s ", str);
  if (ur->phNoLocal)
    printf("%s ", words2PhNo(str, ur->phNoArea, ur->phNoLocal));
  else
    printf("N/A ");
  printf("%d ", (int)PRIORITY(ur->flags));
  printf("%d ", ur->tLeft);
  printf("%d ", ur->tLimit);
  printf("%d ", ur->credit);
  printf("%d ", ur->sLimit);
  bytes2ASCII(str, ur->bTx);
  printf("%s ", str);
  bytes2ASCII(str, ur->bRx);
  printf("%s ", str);
  bytes2ASCII(str, ur->bTxLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bRxLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bStxLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bSrxLimit);
  printf("%s ", str);
  bytes2ASCII(str, ur->bSlimit);
  printf("%s ", str);
  if (ur->expire) {
    if (EXPIRE(ur->flags) == EXPIRE_DELETE)
      printf("DELETE ");
    else
      printf("UNSUBSCRIBE ");
  } else
    printf("N/A ");
  printf("%lu\n", ur->expire);
}
