/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2001  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <sys/types.h>
#include "common.h"

int acua_kickUser(int argc, char **argv)
{

    int         i,
    		uid,
                kicked;
    word        myHostAddr;
    char        hostname[256];
    UserRec     ur;

    if (argc < 2)
    {
	printf("usage: acua kick <user>\n");
	return(1);
    }

    gethostname(hostname, 256);
    myHostAddr = hostAddr(hostname);
    readConfig();
    userFileOpen();

    uid = UIDfromLogin(argv[1]);

    if (userFileSearch(&ur, uid))
    {
	printf("user not found: %s\n", argv[1]);
	return(1);
    }

    kicked = 0;

    for (i = 0; i < MAX_LOGINS; i++)
	if (ur.conninfo.host[i] == myHostAddr)
	{
	    killProcess(ur.conninfo.pid[i]);
	    kicked++;
	    conninfoReset(&ur, i);
	}

    if (!kicked)
    {
	printf("the user is not logged into this host: %s\n", argv[1]);
	return(1);
    }

    userFileEdit(&ur);

    printf("user kicked: %s\n", argv[1]);

    return(0);
}
