/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include "security.h"
#include "common.h"

void usage(void)
{
    printf("usage: acua_logout_pppoe [-k] <login> <pppd_pid>\n");
    return;
}


int
main(int argc, char **argv)
{
    uid_t                    uid = getuid();
    int                      i,
                             hostIdx,
    			     sessionLength;
    char                    *login,
                             hostname[256];
    word   		     myHostAddr;
    time_t		     t;
    pid_t		     pid;
    UserRec		     ur;
    Boolean 		     kick = TRUE;


    if ((argc == 2) && (!strcmp(argv[1], "-k")))
    {
	if (getuid() == 0)
	    kick = FALSE;
	else
	    errQuit("Only root can specify '-k', aborting.");
    }

    login = getLoginName();
    if (!login)
	return(1);  /* could not determine username */

    /* check that the type of login is supported */
    if (loginType() == CONN_NONE)
	return(1);  /* whats this user playing at?!? */

    /* Security checks.  We probably can't catch every situation but
     * it's better to try to catch out malicious users than to not try
     * at all.
     */
    if (securityCheck(loginType(), login) != SECURITY_OK)
        return(1);  /* Who cares, just bail.  acua_updated will fix it. */

    uid = UIDfromLogin(login);

    readConfig();

    userFileOpen();

    if (userFileSearch(&ur, uid))
	goto fail;

    gethostname(hostname, 256);
    myHostAddr = hostAddr(hostname);
    hostIdx = findHost(&ur, myHostAddr);

    if (hostIdx < 0)
	goto fail;

    t = time(NULL);

    sessionLength = (t - ur.lastLogin[hostIdx]) / 60;
    if (sessionLength < optMinDeduct)
    {
	ur.tLeft -= (optMinDeduct - sessionLength);
	ur.sLeft = ur.sLimit - optMinDeduct;
    }
    removeHost(&ur, myHostAddr);
    /* reset appropriate part of conninfo struct */
    pid = getppid();
    for (i = 0; i < MAX_LOGINS; i++)
	if ((ur.conninfo.type[i] != CONN_NONE) &&
	    (ur.conninfo.pid[i] == pid) &&
	    (ur.conninfo.host[i] == myHostAddr))
	{
	    conninfoReset(&ur, i);
	    break;
	}

    userFileEdit(&ur);
    userFileClose();

    /* exit right away if we're not kicking the user off */
    if (!kick)
    {
	return 0;
    }

    /* Become a daemon so the user can logout normally */
    daemonInit();

    /* Allow 5 seconds for them to leave */
    sleep(5);

    /* If this was a malicious user playing games, they're gonna learn
     * the hard way, but otherwise this will kick the user in question.
     */
    killProcess(pid);
    return(0);
fail:
    userFileClose();
    return(1);
}


