/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include "common.h"

int
acua_subscribe(int argc, char **argv)
{
  int                      i;
  uid_t                    uid;
  UserRec                  ur;
  int                      session_limit,
                           priority;

  readConfig();
  if (argc < 4)
    errQuit("\
usage: subscribe <login> <expire> <time_limit> [session_limit] [priority]\n\
                 {class_limit}");
  session_limit = argc >= 5 ? atoi(argv[4]) : atoi(argv[3]);
  priority = argc >= 6 ? atoi(argv[5]) : 4;
  if (priority < 0 || priority > 7)
    errQuit("invalid priority: %d", priority);
  uid = UIDfromLogin(argv[1]);
  if (uid == (uid_t) - 1)
    errQuit("user does not exist: %s", argv[1]);
  userFileOpen();
  if (userFileSearch(&ur, uid))
    errQuit("user not found: %s", argv[1]);
  if (EXPIRE(ur.flags) == EXPIRE_UNSUBSCRIBE)
    errQuit("user already has a subscription: %s", argv[1]);
  time(&ur.subscrDate);
  ur.subExpire = ur.expire;
  ur.subFlags = ur.flags;
  ur.subMaxLogins = ur.maxLogins;
  ur.subMaxDeduct = ur.maxDeduct;
  ur.subIdleLimit = ur.idleLimit;
  ur.subPPPidleMinutes = ur.PPPidleMinutes;
  ur.subPPPidleBytes = ur.PPPidleBytes;
  ur.subTlimit = ur.tLimit;
  ur.subCredit = ur.credit;
  ur.subSlimit = ur.sLimit;
  for (i = 0; i < MAX_TIME_CLASSES; i++)
    ur.subClimit[i] = ur.cLimit[i];
  ur.subBtxLimit = ur.bTxLimit;
  ur.subBrxLimit = ur.bRxLimit;
  ur.subBlimit = ur.bLimit;
  ur.subBStxLimit = ur.bStxLimit;
  ur.subBSrxLimit = ur.bSrxLimit;
  ur.subBSlimit = ur.bSlimit;
  ur.expire = addTime(time(NULL), argv[2]);
  if (ur.expire <= time(NULL))
    errQuit("illegal expiry date.");
  ur.tLimit = ur.tLeft = atoi(argv[3]);
  ur.sLimit = ur.sLeft = session_limit;
  for (i = 0; i < MAX_TIME_CLASSES; i++) {
    ur.cLeft[i] = 0;
    ur.cLimit[i] = -1;
  }
  for (i = 6; i < min(6 + MAX_TIME_CLASSES, argc); i++)
    ur.cLeft[i - 6] = ur.cLimit[i - 6] = atoi(argv[i]);
  ur.flags &= ~FLG_PRIORITY;
  ur.flags |= priority << 13;
  ur.flags &= ~FLG_EXPIRE;
  ur.flags |= EXPIRE_UNSUBSCRIBE;
  userFileEdit(&ur);
  userFileClose();
  printf("user subscribed: %s\n", argv[1]);
  return 0;
}
