/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2000  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#include <assert.h>
#include <ctype.h>
#include <limits.h>
#include <string.h>
#include <sys/stat.h>
#include "common.h"

static int               nLoginRecs;
static LoginRec          loginRec[MAX_USERS];

int
acua_timeLeft(int argc, char **argv)
{
    int                      i,
    			     found = 0,
    			     curClass;
    char                     login[MAX_LOGINCHARS + 1],
			     ttyName[16];
    uid_t                    uid = geteuid();
    UserRec                  ur;
    dev_t                    j, devNo;
    int                      sLeft = INT_MAX;

    readConfig();
    if (argc == 2)
	strncpy(login, argv[1], sizeof(login));
    else
	loginFromUID(login, uid);
    strcpy(ttyName, ttyname(STDIN_FILENO));
    devNo = devNumFromName(ttyName + 5);
    if (lineNo(devNo) < 0)
	goto l0;
    if (!strcmp(login, "guest"))
    {
	userList(&nLoginRecs, loginRec);
	j = devNumFromName(ttyName + 5);
	for (i = 0; i < nLoginRecs; i++)
	    if (loginRec[i].tty == j)
	    {
		found = 1;
		ur.tLeft = (optGuestTime * 60 - (time(NULL) - loginRec[i].time)) / 60 + 1;
		ur.sLeft = ur.tLeft;
		for (j = 0; j < MAX_TIME_CLASSES; j++)
		    ur.cLeft[j] = ur.cLimit[j] = -1;
	    }
    } else {
	userFileOpen();
	if (!userFileSearch(&ur, uid))
	    found = 1;
	userFileClose();
    }
    if (found) {
	curClass = curTimeClass(&ur);
	if (ur.tLimit >= 0)
	    sLeft = min(sLeft, ur.tLeft);
	if (ur.sLimit >= 0)
	    sLeft = min(sLeft, ur.sLeft);
	if ((curClass >= 0) && (ur.cLimit[curClass] >= 0))
	    sLeft = min(sLeft, ur.cLeft[curClass]);
    }
l0:
    if (sLeft == INT_MAX)
	printf("no time limit!\n");
    else {
	printf("%d minute(s) remaining in this accounting period.\n", ur.tLeft);
	printf("%d minute(s) remaining in this session.\n", sLeft);
    }
    return 0;
}
