
/*   ACUA - Access Control and User Administration.
 *   Copyright (C) 2001  Robert Davidson.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   You may not sell ACUA or any part of ACUA for profit.
 */

#ifndef _ACUA_SECURITY_H
#define _ACUA_SECURITY_H

/* Security check return types */

/* Security checks passed */
#define SECURITY_OK             50
/* The user running acua_login does not own the terminal he/she is using */
#define SECURITY_TERM_OWNER     51
/* The UID of LOGNAME does not match our UID */
#define SECURITY_LOGNAME_UID    52
/* The user in the LOGNAME environment variable does not exist */
#define SECURITY_UNKNOWN_USER   53
/* Someone seems to be trying to spoof a PPP / PPPoE connection */
#define SECURITY_PPP_SPOOFED    54
/* Unknown connection type */
#define SECURITY_CONN_TYPE      55
/* stat() failed */
#define SECURITY_STAT_FAILED    56
/* Someone seems to be trying to spoof a CIPE connection */
#define SECURITY_CIPE_SPOOFED   57


#endif
