/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999 Rami Lehti
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <errno.h>
#include "db_config.h"

FILE* be_init(int inout,url_t* u)
{
  FILE* fh=NULL;
  long a=0;
  char* err=NULL;

  switch (u->type) {
  case url_file : {
    fh=fopen(u->value,inout?"r":"w+");
    if(fh==NULL)
      error(0,"Couldn't open file %s for %s",u->value,
	    inout?"reading\n":"writing\n");

    return fh;
  }
  case url_stdout : {
    return stdout;
  }
  case url_stdin : {
    return stdin;
  }
  case url_stderr : {
    return stderr;
  }
  case url_fd : {
    a=strtol(u->value,&err,10);
    if(*err!='\0'||errno==ERANGE){
      error(0,"Illegal file descriptor value:%s\n",u->value);
    }
    fh=fdopen(a,inout?"r":"w");
    if(fh=NULL){
      error(0,"Couldn't reopen file descriptor %i\n",a);
    }
    return fh;
  }
  default:{
    error(0,"Unsupported backend:%i", u->type);
  }    
  }


}
