/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999 Rami Lehti, Pablo Virolainen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "db_config.h"
#include "list.h"
#include "do_md.h"
#include "cipher.h"

list* do_md(list* file_lst)
{
  list* l=NULL;
  db_line* dl=NULL;
  MD_HANDLE mdh;
  FILE* fh=NULL;
  void* buf=NULL;
  size_t bread;
  byte* mdres=NULL;

  mdh=md_open(0,0);
  
  buf=(void*)malloc(BUFSIZE);

  for(l=file_lst;l;l=l->next){
    dl=(db_line*)l->data;
    if(!(dl->md5||dl->sha1||dl->tiger||dl->rmd160))
       continue;

    if(dl->md5)
      md_enable(mdh,DIGEST_ALGO_MD5);
    if(dl->sha1)
      md_enable(mdh,DIGEST_ALGO_SHA1);
    if(dl->tiger)
      md_enable(mdh,DIGEST_ALGO_TIGER);
    if(dl->rmd160)
      md_enable(mdh,DIGEST_ALGO_RMD160);
    
    error(220,"Opening %s for md check\n",dl->filename);
    if(!(fh=fopen(dl->filename,"r"))){
      error(5,"do_md():fopen() for %s failed:%s\n",
	    dl->filename,strerror(errno));
      dl->md5=NULL;
      dl->sha1=NULL;
      dl->tiger=NULL;
      dl->rmd160=NULL;
      continue;
    }
    /* Let's read */
    do{
      /* fread arguments must be 1 and BUFSIZE not BUFSIZE and 1 */
      bread=fread(buf,1,BUFSIZE,fh);
      md_write(mdh,(byte*)buf,bread);
    }
    while(!feof(fh) && bread>0);
    if(bread==0 && !feof(fh)){
      error(5,"read error while reading %s\n", dl->filename);
      dl->md5=NULL;
      dl->sha1=NULL;
      dl->tiger=NULL;
      dl->rmd160=NULL;
      fclose(fh);
      continue;
    }
    if(fclose(fh)){
      error(5,"do_md():fclose() for %s failed:%s\n",
	    dl->filename,strerror(errno));
    }
    md_final(mdh); /* Let's flush the buffers */

    if(dl->md5){
      dl->md5=(byte*)malloc(md_digest_length(DIGEST_ALGO_MD5));
      strncpy(dl->md5,md_read(mdh,DIGEST_ALGO_MD5),
	      md_digest_length(DIGEST_ALGO_MD5));
    }
    if(dl->sha1){
      dl->sha1=(byte*)malloc(md_digest_length(DIGEST_ALGO_SHA1));
      strncpy(dl->sha1,md_read(mdh,DIGEST_ALGO_SHA1),
	      md_digest_length(DIGEST_ALGO_SHA1));
    }
    if(dl->tiger){
      dl->tiger=(byte*)malloc(md_digest_length(DIGEST_ALGO_TIGER));
      strncpy(dl->tiger,md_read(mdh,DIGEST_ALGO_TIGER),
	      md_digest_length(DIGEST_ALGO_TIGER));
    }
    if(dl->rmd160){
      dl->rmd160=(byte*)malloc(md_digest_length(DIGEST_ALGO_RMD160));
      strncpy(dl->rmd160,md_read(mdh,DIGEST_ALGO_RMD160),
	      md_digest_length(DIGEST_ALGO_RMD160));
    }

    md_reset(mdh);

  }

  md_close(mdh);
  return file_lst;
}
