/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999 Rami Lehti,Pablo Virolainen
 * $Header: /home/rammer/warez/aide/src/RCS/list.c,v 1.10 1999/08/17 06:02:49 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdlib.h>
#include "list.h"

/* list
 * limitations:
 * Only the head knows where the tail is
 * Every item knows where the head is
 */

/* list_append()
 * append an item to list
 * returns the head
 * The first argument is the head of the list
 * The second argument is the data to be added
 * Returns list head
 */
list* list_append(list* listp,void*data)
{
  list* newitem=NULL;
  newitem=(list*)malloc(sizeof(list));

  if(listp==NULL){
    newitem->data=data;
    newitem->head=newitem;
    newitem->tail=newitem;
    newitem->next=NULL;
    newitem->prev=NULL;
    return newitem;
  }else {
    listp->tail->next=newitem;
    newitem->prev=listp->tail;
    newitem->next=NULL;
    newitem->head=listp->head;
    newitem->data=data;
    newitem->tail=NULL;
    listp->head->tail=newitem;
    return listp;
  }
  /* Not reached */
  return NULL;
}

/*
 * new_list_item()
 * create a new list item with data
 */
list* new_list_item(void* data)
{
  list* item=NULL;

  item=(list*)malloc(sizeof(list));
  item->prev=NULL;
  item->next=NULL;
  item->head=item;
  item->tail=item;
  item->data=data;

  return item;
}

/*
 * delete_list_item()
 * delete a item from list
 */

list* list_delete_item(list* item){
  list* r;
    
  if (item->head==item->head->tail) {
    /*
     * Ollaan poistamassa listan ainoaa alkiota.
     * Tllin palautetaan NULL
     */
    free(item);
    return NULL;
  }
  
  /* 
   * Nyt meill on listassa ainakin kaksi alkiota 
   *  
   */

  if (item==item->head->tail){
    
    r=item->head;
    item->head->tail=item->prev;
    item->prev->next=NULL;
    free(item);
    return r;
  }
  
  if (item==item->head) {

    /*
     * Poistetaan listan ensimminen alkio.
     */
    
    list* i=item->next;
    i->prev=NULL;
    r=i;
    r->tail=item->tail;
    
    free(item);
    
    while(i!=NULL){
      i->head=r;
      i=i->next;
    }
    return r;
  }
  
  r=item->prev;

  item->prev->next=item->next;
  item->next->prev=item->prev;
  
  free(item);

  return r;
  
}
