/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999,2000 Rami Lehti,Pablo Virolainen
 * $Header: /cvs-root-aide/aide/include/seltree.h,v 1.8 2000/04/20 12:44:53 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _SELTREE_H_INCLUDED
#define _SELTREE_H_INCLUDED
#include "list.h"


/* seltree structure
 * lists have regex_t* in them
 * checked is whether or not the node has been checked yet
 * path is the path of the node
 * parent is the parent, NULL if root
 * childs is list of seltree*:s
 */

typedef struct seltree {
  list* sel_rx_lst;
  list* neg_rx_lst;
  list* equ_rx_lst;
  list* childs;
  struct seltree* parent;
  char* path;
  int checked;
} seltree;

#endif /* _SELTREE_H_INCLUDED*/
