/*-
 *
 * Audit Daemon for Linux (v1.11)
 *
 * Copyright (C) 1999 Hacker Emergency Response Team
 * Markus Wolf <klog@hert.org>, Promisc Security 
 *
 * This file is part of Audit Daemon
 * 
 * Audit Daemon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * Audit Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 *
 */


#include <stdio.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <time.h>
#include <getopt.h>
#include "audit.h" 

int logpos;
int usetime;

die(char *msg)
{
	perror(msg);
	exit(-1);
}

int getline(int fd, char *buf, int len)
{
        char chr;
        int i;

	bzero(buf, len);
        for(i=0;i<len;i++) {
		if (read(fd, &chr, 1) == 0) return -1;
                if ((chr=='\n')||(chr==0)) return;
                buf[i] = chr;
        }
}

/* To be used to get both strings and integers */
int getunit(char *src, char *dst, int len)
{
        int i;

	bzero(dst, len);
	for(i=0;i<(len-1);logpos++,i++) {
                if (src[logpos]==' ') { logpos++; break; }
		if (src[logpos]==0) { logpos++; break; }
                dst[i] = src[logpos];
        }
	return (atol(dst));
}

void logline(char *buf)
{
	int flag, pid, uid;
	char pname[17];
	char info[1024];
	char tmp[20];
	char *date;
	time_t t;
	FILE *logfd;

	logpos = 0;

        flag = getunit(buf, tmp, sizeof(tmp));
        getunit(buf, pname, sizeof(pname));
	pid = getunit(buf, tmp, sizeof(tmp));
	uid = getunit(buf, tmp, sizeof(tmp));

	if ((flag < 'a')||(flag > 'z')) return; /* crapped */

	logfd = (FILE *)get_logfd(flag, pname, pid, uid);
	if (logfd == NULL) return;

	if (usetime) {
		t = time(NULL);
		date = ctime(&t);
		date[strlen(date)-5] = 0; /* remove the year */
		fprintf(logfd, "%s", date);
	}
	fprintf(logfd, "%s[%d]: ", pname, uid);

	switch(flag) {
	    case AUDIT_CONNECT:
		log_socket(logfd, buf, "connect", "-->"); break;
            case AUDIT_ACCEPT:
		log_socket(logfd, buf, "accept", "<--"); break;
            case AUDIT_LISTEN:
		log_socket(logfd, buf, "listen", NULL); break;
	    case AUDIT_OPEN:
		log_file(logfd, buf, "open"); break;
	    case AUDIT_SETUID:
		log_setuid(logfd, buf, "setuid"); break;
	    case AUDIT_EXEC:
		log_file(logfd, buf, "exec"); break;
	    case AUDIT_MODINIT:
		log_file(logfd, buf, "modinit"); break;
	}
	fflush(logfd);
}

main(int argc, char *argv[])
{
	int conffd;
	int srcfd;
	char buf[1024];

	/* No need for getopt() for now... */
	if (argc > 1)
		if (strcmp(argv[1], "-t") == 0)
			usetime = 1;


	srcfd = open(AUDIT_SRC_PATH, O_RDONLY); 
	if (srcfd < 0) die(AUDIT_SRC_PATH);
	conffd = open(AUDIT_CONF_PATH, O_RDONLY);
	if (conffd <0) die(AUDIT_CONF_PATH);
	
	init_conf(conffd);

	if (!fork()) {
		while(1) {
			bzero(&buf, sizeof(buf));
			getline(srcfd, buf, sizeof(buf));
		 	logline(buf);
		}
	}
	exit(0);
}
