/*-
 *
 * Audit Daemon for Linux (v1.11) 
 * Markus Wolf <klog@hert.org>, Promisc Security
 *
 * Copyright (C) 1999 Hacker Emergency Response Team
 * http://www.hert.org
 *
 * This file is part of Audit Daemon
 * 
 * Audit Daemon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * Audit Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 *
 */

#include <stdio.h>
#include <strings.h>

struct rule {
	char flags[12];
	char pname[17];
	char uid[8];	/* There may be special chars (like '*') */
	char pid[8];
	FILE *logfd;
};

struct log {
	char filename[256];
	FILE *logfd;
};

int confpos;
struct rule *rules = NULL;
int rulessz;
struct log *logs = NULL;
int logssz;

int getelem(char *src, char *dst, int len)
{
        int i;

        bzero(dst, len);
        for(i=0;i<(len-1);confpos++,i++) {
                if (src[confpos]==':') { confpos++; break; }
                if (src[confpos]==0) { confpos++; break; }
                dst[i] = src[confpos];
        }
        return (atol(dst));
}

FILE *open_log(char *filename)
{
	FILE *fd;
        int ind, i;

	ind = (logssz/sizeof(struct log));
	for(i=0;i<ind;i++) {
		if (strcmp(logs[i].filename, filename)==0) 
			return logs[i].logfd;
	}

        logssz += sizeof(struct log);
        logs = (struct log *)xmalloc(logs, logssz);

	fd = fopen(filename, "a+");
	if (fd == NULL) die(filename);

	strcpy(logs[ind].filename, filename);
	logs[ind].logfd = fd;

	return fd;
}

void parse_rule(char *buf)
{
	int ind;
	char flags[12];
	char pid[8], uid[8];
	char filename[256];
	char pname[17];

	rulessz += sizeof(struct rule);
	rules = (struct rule *)xmalloc(rules, rulessz);
	ind = (rulessz/sizeof(struct rule))-1;		

	getelem(buf, flags, sizeof(flags));
	getelem(buf, pname, sizeof(pname));
	getelem(buf, pid, sizeof(pid));
	getelem(buf, uid, sizeof(uid));
	getelem(buf, filename, sizeof(filename));

	strcpy(rules[ind].flags, flags);
	strcpy(rules[ind].pname, pname);
	strcpy(rules[ind].pid, pid);
	strcpy(rules[ind].uid, uid);
	rules[ind].logfd = open_log(filename);
}

FILE *get_logfd(int flag, char *pname, int pid, int uid)
{
	int rules_max, i;

	rules_max = rulessz/sizeof(struct rule);
	for (i=0;i<rules_max;i++) {
		if (((strchr(rules[i].flags, flag) != NULL)
		     || (rules[i].flags[0]=='*'))
		    && ((strcmp(rules[i].pname, pname) == 0)
		     || (rules[i].pname[0]=='*')) 
		    && ((atol(rules[i].pid) == pid)
		     || (rules[i].pid[0]=='*'))
		    && ((atol(rules[i].uid) == uid)
		     || (rules[i].uid[0]=='*')))
		return rules[i].logfd;
	}
	return NULL;
}

void init_conf(int fd)
{
	char buf[256];
	char type[20];

	while(1) {
		confpos=0;
		if (getline(fd, buf, sizeof(buf)) < 0) break;
		getelem(buf, type, sizeof(type));
		if (strcmp(type, "log")==0) parse_rule(buf);
	}
} 
