/*-
 *
 * Audit Daemon for Linux (v1.11) 
 * Markus Wolf <klog@hert.org>, Promisc Security
 *
 * Copyright (C) 1999 Hacker Emergency Response Team
 * http://www.hert.org
 *
 * This file is part of Audit Daemon
 * 
 * Audit Daemon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * Audit Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 *
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include "../audit.h"

#define ISFILE(x)  (strchr((x), AUDIT_OPEN)) || \
                   (strchr((x), AUDIT_EXEC)) || \
                   (strchr((x), AUDIT_MODINIT))

#define PATHLEN 1024

struct rule {
	char flags[12];
	char pname[17];
	char uid[8];	/* There may be special chars (like '*') */
	char pid[8];
	char file[PATHLEN];
	FILE *logfd;
};

struct log {
	char filename[PATHLEN];
	FILE *logfd;
};

int confpos;
struct rule *rules = NULL;
int rulessz;
struct log *logs = NULL;
int logssz;
extern int debug;

FILE *open_log(char *filename)
{
	FILE *fd;
        int ind, i;

	ind = (logssz/sizeof(struct log));
	for(i=0;i<ind;i++) {
		if (strcmp(logs[i].filename, filename)==0) 
			return logs[i].logfd;
	}

        logssz += sizeof(struct log);
        logs = (struct log *)xmalloc(logs, logssz);

	fd = fopen(filename, "a+");
	if (fd == NULL) die(filename);

	strcpy(logs[ind].filename, filename);
	logs[ind].logfd = fd;

	return fd;
}

void parse_rule(char *buf)
{
	int ind, rslt;
	char logfile[1024], key[10];

	rulessz += sizeof(struct rule);
	rules = (struct rule *)xmalloc(rules, rulessz);
	ind = (rulessz/sizeof(struct rule))-1;		

	bzero(logfile, sizeof(logfile));
	sscanf(buf, "%10s %11s %16s %7s %7s %1023s %1023s", 
		&key, 
		&rules[ind].flags, &rules[ind].pname,
		&rules[ind].pid, 
		&rules[ind].uid, &rules[ind].file,
		&logfile);

	if (logfile[0]!='/') {
        	rules[ind].logfd = open_log(rules[ind].file);
		rules[ind].file[0] = '*';
	} else {
                rules[ind].logfd = open_log(logfile);
	}

	if (debug) printf("%s %s %s %s %s %i\n",
			rules[ind].flags,
			rules[ind].pname,
			rules[ind].pid,
			rules[ind].uid,
			rules[ind].file,
			rules[ind].logfd);
}

FILE *get_logfd(int flag, char *pname, int pid, int uid, char *file)
{
	int rules_max, i;

	rules_max = rulessz/sizeof(struct rule);
	for (i=0;i<rules_max;i++) {
		if (((strchr(rules[i].flags, flag) != NULL)
		     || (rules[i].flags[0]=='*'))
		    && ((strcmp(rules[i].pname, pname) == 0)
		     || (rules[i].pname[0]=='*')) 
		    && ((atol(rules[i].pid) == pid)
		     || (rules[i].pid[0]=='*'))
		    && ((atol(rules[i].uid) == uid)
		     || (rules[i].uid[0]=='*'))
		    && (!(ISFILE(rules[i].flags)) 
		     || (!strcmp(rules[i].file, file))
	 	     || (rules[i].file[0]=='*')))
		return rules[i].logfd;
	}
	return NULL;
}

void init_conf()
{
	char buf[2048];
	char type[20];
	FILE *conffd;

        conffd = fopen(CONFPATH, "r");
        if (!conffd) die(CONFPATH);

	while(1) {
		if (!fgets(buf, sizeof(buf), conffd)) break;
		if (buf[0]!='#'&&buf[0]!='\n'&&buf[0]!=' ') 
			parse_rule(buf);
	};
} 
