/*-
 *
 * Audit Daemon for Linux (v1.11) 
 * Markus Wolf <klog@hert.org>, Promisc Security
 *
 * Copyright (C) 1999 Hacker Emergency Response Team
 * http://www.hert.org
 *
 * This file is part of Audit Daemon
 * 
 * Audit Daemon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * Audit Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 *
 */

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include "../audit.h" 

extern int logpos;

void log_socket(FILE *fd, char *buf, char *type, char *link, int netorder)
{
        char tmp[20];
        int sport, dport;
        struct in_addr source, dest;
        char *sip, *dip, saddr[20], daddr[20];

        source.s_addr = getunit(buf, tmp, sizeof(tmp));
        sport = getunit(buf, tmp, sizeof(tmp));
        sip = inet_ntoa(source); strcpy(saddr, sip);

        if (link != NULL) {
                dest.s_addr = getunit(buf, tmp, sizeof(tmp));
                dport = getunit(buf, tmp, sizeof(tmp));
                dip = inet_ntoa(dest); strcpy(daddr, dip);
        }

        if (link == NULL) {
                fprintf(fd, "%s(%s:%d)\n", type, saddr, sport);
        } else {
                fprintf(fd, "%s(%s:%d %s %s:%d)\n", type,
                        saddr, sport, 
			link, daddr, ntohs(dport));

        }
}

void log_file(FILE *fd, char *buf, char *type)
{
        char filename[64];

        getunit(buf, filename, sizeof(filename));
        fprintf(fd, "%s(\"%s\")\n", type, filename);
}

void log_debug(FILE *fd, char *buf, char *type)
{
	fprintf(fd, "<%s> %s \n", type, buf+logpos);
}

void log_setuid(FILE *fd, char *buf, char *type)
{
        int ruid, euid;
        char tmp[20];

        ruid = getunit(buf, tmp, sizeof(tmp));
        euid = getunit(buf, tmp, sizeof(tmp));

        fprintf(fd, "%s(%d, %d)\n", type, ruid, euid);
}

