/*-
 *
 * Audit Daemon for Linux (v1.11) 
 * Markus Wolf <klog@hert.org>, Promisc Security
 *
 * Copyright (C) 1999 Hacker Emergency Response Team
 * http://www.hert.org
 *
 * This file is part of Audit Daemon
 * 
 * Audit Daemon is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * Audit Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 * 
 */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/poll.h>

#include <asm/uaccess.h>
#include <asm/io.h>

extern unsigned long audit_size;
extern struct wait_queue *audit_wait;
asmlinkage int sys_audit(char *buf, int count);

static int audit_read(struct file *file, char * buf,size_t count, loff_t *ppos)
{
	return sys_audit(buf,count);
}

static int audit_poll(struct file *file, poll_table *wait)
{
        poll_wait(file, &audit_wait, wait);
        if (audit_size)
                return POLLIN | POLLRDNORM;
        return 0;
}


static struct file_operations proc_audit_operations = {
	NULL,		
	audit_read,
	NULL,	
	NULL,		
	audit_poll,	
	NULL,		
	NULL,		
	NULL,
	NULL,
	NULL,
	NULL		
};

struct inode_operations proc_audit_inode_operations = {
	&proc_audit_operations,	/* default base directory file-ops */
        NULL,                   /* create */
        NULL,                   /* lookup */
        NULL,                   /* link */
        NULL,                   /* unlink */
        NULL,                   /* symlink */
        NULL,                   /* mkdir */
        NULL,                   /* rmdir */
        NULL,                   /* mknod */
        NULL,                   /* rename */
        NULL,                   /* readlink */
        NULL,                   /* follow_link */
        NULL,                   /* readpage */
        NULL,                   /* writepage */
        NULL,                   /* bmap */
        NULL,                   /* truncate */
        NULL                    /* permission */
};

