#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <stdarg.h>

#include "../audit.h"

static int audit_sock;
static char audit_id[255];

int audit_init(char *id)
{
	struct sockaddr addr;
	
	addr.sa_family = AF_UNIX;
	strncpy(&addr.sa_data, SOCKPATH, sizeof(addr.sa_data));

	audit_sock = socket(AF_UNIX, SOCK_DGRAM, 0);
	connect(audit_sock, &addr, sizeof(addr));

	strncpy(audit_id, id, sizeof(audit_id));
}

int audit(const char *fmt, ...)
{
        va_list args;
	char debug[AUDIT_BUF_LEN-255];
	char buf[AUDIT_BUF_LEN];

	va_start(args, fmt);
	vsnprintf(debug, sizeof(debug), fmt, args);
        va_end(args);
	snprintf(buf, sizeof(buf), "%d %s %d %d %s", AUDIT_DEBUG, audit_id,  
		 getpid(), getuid(), debug);

	send(audit_sock, buf, sizeof(buf), 0);
}
	
int audit_end()
{
	return close(audit_sock);
}

openlog(char *ident, int option, int  facility)
{
	audit_init(ident);
}

syslog(int priority, char *fmt, ...)
{
        va_list args;
        char debug[AUDIT_BUF_LEN-255];

        va_start(args, fmt);
        vsnprintf(debug, sizeof(debug), fmt, args);
        va_end(args);

	audit(debug);
}

closelog()
{
	audit_end();
}
