#define MODULE
#define __KERNEL__
#define MODVERSIONS

#include <linux/config.h>
#include <linux/module.h>
#include <linux/modversions.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>
#include <linux/poll.h>
#include <linux/sched.h>
#include <linux/net.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <asm/segment.h>
#include <net/sock.h>
#include <sys/syscall.h>

/* Old kernels
#include <sys/socketcall.h>
*/

#include <linux/net.h>

#include <linux/tty_driver.h>
#include <linux/smp_lock.h>
#include <linux/console.h>
#include <linux/init.h>
#include <asm/uaccess.h>
#include <asm/bitops.h>
#include "../audit.h"
#include "modkaf.h"

/*-
 * 	/proc/audit read() system call.
 */

asmlinkage int sys_audit(char *buf, int len)
{
        unsigned long i;
        char c;
        int error;

        if (!suser())
                return -EPERM;
        if (!buf || len < 0)
                return -EINVAL;
        if (!len)
                return 0;
        error = verify_area(VERIFY_WRITE,buf,len);
        if (error)
                return error;
        error = wait_event_interruptible(audit_wait, audit_size);
        if (error)
		return error;
        i = 0;
        while (audit_size && i < len) {
        	c = *((char *) audit_buf+audit_start);
        	audit_start++;
        	audit_size--;
        	audit_start &= AUDIT_BUF_LEN-1;
        	sti();
        	put_user(c,buf);
                buf++;
                i++;
                cli();
        }
        sti();
        return i;
}

/*-
 *	Audit trail buffering function.
 */

asmlinkage int audit(const char *fmt, ...)
{
        va_list args;
        int i;
        char *p, *buf_end;
        long flags;

        save_flags(flags);
        cli();
        va_start(args, fmt);
	
        i = vsprintf(buf, fmt, args); 
        buf_end = buf + i;
        va_end(args);

        for (p=buf; p < buf_end; p++) {
                audit_buf[(audit_start+audit_size) & (AUDIT_BUF_LEN-1)] = *p;
                if (audit_size < AUDIT_BUF_LEN)
                        audit_size++;
                else {
                        audit_start++;
                        audit_start &= AUDIT_BUF_LEN-1;
                }
                audit_chars++;
                if (*p == '\n')
                        break;
        }

        restore_flags(flags);
        wake_up_interruptible(&audit_wait);
        return i;
}

/*-
 *	Many system call wrappers...
 */

int new_setreuid(uid_t ruid, uid_t euid)
{
	int retval;
	uid_t old_ruid = current->uid;
	uid_t old_euid = current->euid;
	retval = (*old_setreuid)(ruid, euid);
	if (retval<0) return retval;
	audit("%d %s %d %d %d %d\n", AUDIT_SETUID, current->comm,
               current->pid, old_ruid, current->uid, current->euid);
	return retval;
}

int new_setuid(uid_t uid)
{
	int retval;
	uid_t old_uid = current->uid;
	retval = (*old_setuid)(uid);
	if (retval<0) return retval;
	audit("%d %s %d %d %d %d\n", AUDIT_SETUID, current->comm,
               current->pid, old_uid, current->uid, current->uid);
	return retval;
}

int new_open(const char * filename, int flags, int mode)
{
	int retval;

	retval = (*old_open)(filename, flags, mode);
	if (retval<0) return retval;
        strncpy(cutbuf, filename, sizeof(cutbuf));
	audit("%d %s %d %d %s\n", AUDIT_OPEN, current->comm,
	       current->pid, current->uid, cutbuf);

	return retval;
}


/* The socketcall part must be changed QUICK */

#define AL(x) ((x) * sizeof(unsigned long))
static unsigned char nargs[18]={AL(0),AL(3),AL(3),AL(3),AL(2),AL(3),
                                AL(3),AL(3),AL(4),AL(4),AL(4),AL(6),
                                AL(6),AL(2),AL(5),AL(5),AL(3),AL(3)};
#undef AL

int new_socketcall(int call, unsigned long *args)
{
	struct sock *sk;
	struct proto_ops *ops;
        unsigned long a[6];
        unsigned long a0,a1;
        int err;

        if (copy_from_user(a, args, nargs[call]))
                return -EFAULT;

        a0=a[0];
        a1=a[1];

        err = (*old_socketcall)(call, args);
	if (err<0) return err;

        switch(call)
        {
                case SYS_CONNECT:
                        sk = current->files->fd[a0]->
                               f_dentry->d_inode->u.socket_i.sk;
                        audit("%d %s %d %d %d %d %d %d\n",
                                AUDIT_CONNECT, current->comm,
                                current->pid, current->uid,
                                sk->rcv_saddr, sk->num, sk->daddr,
                                sk->dport);
                        break;
                case SYS_LISTEN:
                        sk = current->files->fd[a0]->
                               f_dentry->d_inode->u.socket_i.sk;
                        audit("%d %s %d %d %d %d\n", AUDIT_LISTEN,
                                current->comm,
                                current->pid, current->uid,
                                sk->rcv_saddr, sk->num);
                        break;
                case SYS_ACCEPT:
                        sk = current->files->fd[err]->
                               f_dentry->d_inode->u.socket_i.sk;
                        audit("%d %s %d %d %d %d %d %d\n",
                                AUDIT_ACCEPT, current->comm,
                                current->pid, current->uid,
                                sk->rcv_saddr, sk->num, sk->daddr,
                                sk->dport);
                        break;
        }
        return err;
}

unsigned long new_create_module(const char *name_user, size_t size)
{
	int retval;

	/* Stealth lkms wont fool us */
	strncpy_from_user(cutbuf, name_user, sizeof(cutbuf));

 	retval = (*old_create_module)(name_user, size);
	if (retval<0) return retval;

        audit("%d %s %d %d %s\n", AUDIT_MODINIT, current->comm,
               current->pid, current->uid, cutbuf);

	return retval;
}

asmlinkage int new_execve(struct pt_regs regs)
{
        int retval;
	char proc_name[16];
	uid_t proc_uid = current->uid;
	pid_t proc_pid = current->pid;
	char *filename;

        lock_kernel();

        filename = getname((char *)regs.ebx);
	strncpy(proc_name, current->comm, 15);

	retval = do_execve(filename, (char **)regs.ecx, 
		           (char **)regs.edx, &regs);

        if (retval<0) goto end; 
	strncpy(cutbuf, filename, sizeof(cutbuf));
	audit("%d %s %d %d %s\n", AUDIT_EXEC, proc_name,
               proc_pid, proc_uid, cutbuf);

end:
	free_pages((long)filename,0);
	unlock_kernel();
	return retval;
}


/*-
 *	modkaf's initialization function.
 */

int init_module()
{
	old_setreuid = sys_call_table[SYS_setreuid];
	old_setuid = sys_call_table[SYS_setuid];
	old_open = sys_call_table[SYS_open];
	old_socketcall = sys_call_table[SYS_socketcall];
	old_create_module = sys_call_table[SYS_create_module];
	old_execve = sys_call_table[SYS_execve];
	sys_call_table[SYS_setreuid] = (void *)new_setreuid;
	sys_call_table[SYS_setuid] = (void *)new_setuid;
	sys_call_table[SYS_open] = (void *)new_open;
	sys_call_table[SYS_socketcall] = (void *)new_socketcall;
	sys_call_table[SYS_create_module] = (void *)new_create_module;
	sys_call_table[SYS_execve] = (void *)new_execve;
        proc_register(&proc_root, &proc_root_audit);

	printk("Auditd KAF loaded (klog@hert.org)\n");
	return 0;
}

/*-
 *	modkaf's clean up function.
 */

int cleanup_module()
{
	sys_call_table[SYS_setreuid] = (void *)old_setreuid;
	sys_call_table[SYS_setuid] = (void *)old_setuid;
	sys_call_table[SYS_open] = (void *)old_open;
	sys_call_table[SYS_socketcall] = (void *)old_socketcall;
	sys_call_table[SYS_create_module] = (void *)old_create_module;
	sys_call_table[SYS_execve] = (void *)old_execve;
	proc_unregister(&proc_root, proc_root_audit.low_ino);

	printk("Auditd KAF removed (klog@hert.org)\n");
	return 0;
}
