

/*-
 *      Symbols we import from the kernel.
 */

extern void *sys_call_table[];

/*-
 *      Storage used by our audit buffer functions.
 */

static char buf[AUDIT_BUF_LEN];
static char audit_buf[AUDIT_BUF_LEN];
struct inode_operations proc_audit_inode_operations;
static unsigned long audit_start = 0;
static unsigned long audit_chars = 0;
unsigned long audit_size = 0;
struct wait_queue *audit_wait = NULL;
static char cutbuf[AUDIT_BUF_LEN-255];

/*-
 *      /proc/audit node structure.
 */

extern unsigned long audit_size;
extern struct wait_queue *audit_wait;

asmlinkage int sys_audit(char *buf, int count);

/*-
 *      /proc/audit fs handlers
 */

static int audit_read(struct file *file, char * buf,size_t count,
                          loff_t *ppos)
{
        return sys_audit(buf,count);
}

static unsigned int audit_poll(struct file *file, poll_table *wait)
{
        poll_wait(file, &audit_wait, wait);
        if (audit_size)
                return POLLIN | POLLRDNORM;
        return 0;
}

/*-
 *	/proc/audit definition
 */

static struct file_operations proc_audit_operations = {
        NULL,
        audit_read,
        NULL,
        NULL,
        audit_poll,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL,
        NULL
};

struct inode_operations proc_audit_inode_operations = {
        &proc_audit_operations, /* default base directory file-ops */
        NULL,                   /* create */
        NULL,                   /* lookup */
        NULL,                   /* link */
        NULL,                   /* unlink */
        NULL,                   /* symlink */
        NULL,                   /* mkdir */
        NULL,                   /* rmdir */
        NULL,                   /* mknod */
        NULL,                   /* rename */
        NULL,                   /* readlink */
        NULL,                   /* follow_link */
        NULL,                   /* readpage */
        NULL,                   /* writepage */
        NULL,                   /* bmap */
        NULL,                   /* truncate */
        NULL                    /* permission */
};

static struct proc_dir_entry proc_root_audit = {
        PROC_AUDIT, 5, "audit",
        S_IFREG | S_IRUSR, 1, 0, 0,
        0, &proc_audit_inode_operations
};

/*-
 *      Saved system calls.
 */

int             (*old_setreuid)(uid_t, uid_t);
int             (*old_setuid)(uid_t);
unsigned long   (*old_create_module)(const char *, size_t);
int             (*old_open)(const char *, int, int);
int             (*old_execve)(struct pt_regs);
int             (*old_socketcall)(int, unsigned long *);


