.\" $Id: console.man,v 1.6 2001-07-05 01:39:15-07 bryan Exp $
.TH CONSOLE 8 "Local"
.SH NAME
console \- console server client program
.SH SYNOPSIS
\fBconsole\fP [\-\fBaAfFsS\fP] [\-\fBrv\fP] [\-\fBe\fP \fIesc\fP] [\-\fBM\fP \fImach\fP] \fIconsole\fP
.br
\fBconsole\fP [\-\fBv\fP] [\-\fBhdDPuVwx\fP] [\-\fBb\fP \fImessage\fP]
.br
\fBconsole\fP [\-\fBqQ\fP] [\-\fBM\fP \fImach\fP]
.SH DESCRIPTION
.B Console
is used to manipulate console terminals remotely or poll running
\fIconserver\fP(8) daemons for status information.
.PP
.B Console
queries the user for the their passwd before
granting interactive access to a console (on a non-trusted system)
since such a session may provide single-user access.
.PP
In the non-interactive mode
.B console
outputs only the requested information.
.SH OPTIONS
.TP
.B \-a
Access a console with a two-way connection (this is the default).
.TP
.BI \-b message
Broadcast a \fImessage\fP to all users connected to the console server.
.TP
.B \-d
Display daemon versions.  The \fIconsole\fP client connects to each
server to request its version information.  The uppercase varient of
this option only requests the primary server's version.
.TP
.B \-D
Same as \fB\-d\fP but just acts on the local server.
.TP
.BI \-e esc
Set the initial two character escape sequence to
those represented by \fIesc\fP.
Any of the forms output by \fIcat\fP(1)'s \-\fBv\fP option
are accepted.  The default value is ``^Ec''.
.TP
.B \-f
Same as \fB\-a\fP except it will force any existing connection into spy mode.
.TP
.B \-h
Display a brief help message.
.TP
.BI \-l user
Sets the username used for authentication to \fIuser\fP.
.TP
.BI \-M mach
The \fIconsole\fP client program polls \fImach\fP as the primary server,
rather than the hard coded default (``console'').
.TP
.BI \-p port
Set the port to connect to.  The default \fIport\fP is set at compile time
using the --with-port option.
.TP
.B \-P
Display the pids of the master daemon processes.
.TP
.B \-q
The \fIconsole\fP client requests the server daemon quit (shutdown).
A password is sent in the protocol stream, if none is required for
the local host to shutdown the server just press return.
.TP
.B \-Q
Same as \fB\-q\fP but just acts on the local server.
.TP
.B \-r
Request a raw connection to the group control virtual console,
this is only useful for learning the protocol used by the
interactive sequence.
.TP
.B \-s
Requests a read-only (spy mode) connection.
If this mode all the escape sequences (below) work, or report errors,
but all other keyboard input is discarded.
.TP
.B \-u
Show a list of all consoles with status and attached users.
.TP
.B \-U
Same as \fB\-u\fP.
.TP
.B \-V
Output the version of the console client program.
.TP
.B \-v
Be more verbose during when building the connection(s).
Use this option in combination with any of `show' options (below)
for added benefit.
.TP
.B \-w
Show a list of all connections to consoles.
.TP
.B \-W
Same as \fB\-w\fP.
.TP
.B \-x
Show a list of consoles and devices.
.PP
The \fB\-A\fP, \fB\-F\fP, or \fB\-S\fP options have the same effect as
their lower case variants.
In addition they each request the last 20 lines of the console output after
making the connection.
.PP
Any default (\fB\-a\fP) connection is dropped to spy mode if
someone else is attached read-write.
.SH "ESCAPE SEQUENCES"
The connection can be controlled by a two character escape sequence, followed
by a command.  The default escape sequence is ``control-E c''
(octal 005 143).  Commands are:
.sp
.TS
c l.
a	switch to attach mode
c	toggle flow control (don't do this)
d	down the current console
e	change the escape sequence to the next two characters
f	force a switch to attach mode
g	group info
L	toggle logging on/off
l1	send a 3-second serial line break (might halt a Sun)
	("ell" then "one", not the L1 key)
o	reopen the line to clear errors (silo overflows)
p	replay the last 60 lines of output
r	replay the last 20 lines of output
s	switch to spy mode
u	show other users on this port
v	show the version of the group server
w	who is using this console
x	examine this group's devices and modes.
z	suspend this connection
?	display list of commands
^M	continue, ignore the escape sequence
^R	replay the last line only
\.	disconnect
.TE
.sp
.PP
If any other character is hit after the escape sequence, all three characters
will be discarded.
Note that a line break or a down command
can only be sent from a full two-way attachment.
To send the escape sequence through the connection one must redefine
the outer escape sequence.
.PP
In the \-u output, the login \fB<none>\fP indicates no one is
viewing that console, the login \fB<spies>\fP indicates that
no one has a full two-way attachment.  When no one is attached to
a console its output is cloned to the stdout of the server process.
.SH EXAMPLES
.TP
console \-u
Outputs something like:
.sp
.RS
.TS
l18 l l.
dumb	up	<none>
expert	up	ksb@mentor
tyro	up	<spies>
mentor	up	<none>
sage	up	fine@cis
.TE
.RE
.sp
The \fB<none>\fP indicates no one is viewing \fIdumb\fP or \fImentor\fP,
the \fB<spies>\fP indicates only read-only connections exist for \fItyro\fP,
other \fIlogin\fP@\fIhost\fP entries are the currently attached
\fIsage\fP and \fIexpert\fP.
.TP
console \-w
Outputs something like:
.sp
.RS
.TS
l18 l l.
ksb@extra	attach 2days	expert
file@cis	attach 21:46	sage
dmr@alice	spy     0:04	tyro
.TE
.RE
.sp
The third column is the idle time of the user.  Either hours:minutes or number
of days is displayed.
.TP
console \-e \*(lq^[1\*(rq lv426
Requests a connection to the host ``lv426'' with the escape characters
set to ``escape one''.
.SH BUGS
Connections suspended under Dynix sometimes break the kernel when
resumed.
.PP
It is possible to create a loop of console connections, with ugly results.
Never run \fIconsole\fP from within a console connection (unless you set each
escape sequence differently).
.PP
The \fB\-r\fP option doesn't help to explain how connections get built.
.SH AUTHORS
Thomas A. Fine, Ohio State Computer Science.
.br
Kevin Braunsdorf, Purdue University Computing Center
.br
Bryan Stansell, conserver.com
.SH "SEE ALSO"
conserver.cf(5), conserver(8)
