.\" $Id: conserver.cf.man,v 1.24 2002-03-25 17:14:34-08 bryan Exp $
.\" @(#)constab.5 01/06/91 OSU CIS; Thomas A. Fine
.TH CONSERVER.CF 5 "Local"
.SH NAME
conserver.cf \- console configuration file for conserver(8)
.SH SYNOPSIS
.br
.BI \s-1LOGDIR\s0= logdirectory
.br
.BI \s-1TIMESTAMP\s0= timestamp-spec
.br
.BI \s-1BREAK\s0\fIn\fP= break-spec
.br
\fIname\fP:\fIdevice\fP[@\fIconserver\fP]:\fIbaud\fP:\fIlogfile\fP:\fItimestamp-spec\fP:\fIbreak\fP
.br
\fIname\fP:!\fItermserver\fP[@\fIconserver\fP]:\fIport\fP:\fIlogfile\fP:\fItimestamp-spec\fP:\fIbreak\fP
.br
\fIname\fP:|\fIcommand\fP[@\fIconserver\fP]::\fIlogfile\fP:\fItimestamp-spec\fP:\fIbreak\fP
.br
\fB%%\fP
.br
\fIaccess\fP: \fIhosts\fP
.SH DESCRIPTION
.B Conserver.cf
is the configuration file for
.BR conserver (8).
It is read once upon startup;
modifications to the file take effect only upon restarting \fBconserver\fP.
.PP
Blank lines and comment lines (those beginning with a ``#'' and
optional leading whitespace) are ignored.  Non-ignored lines
beginning with whitespace are considered continuations of the
previous line.  This allows you to span one logical line over
many physical lines and insert comments wherever appropriate.
.PP
The first section of the file has logical lines that are separated into
five colon-separated fields.  Leading and trailing white space in each
field is ignored.
.TP
.I name
the unique name by which this connection is referred to
when using the \fBconsole\fP program.
This is typically the name of the host whose console is being monitored.
.TP
.I device
the full path name of the device for this line.
The \fIbaud\fP rate is the speed and parity for this console.
Speed may be given as an integer,
parity only requires the first letter of any of: even, odd, mark, space.
For no parity, use the character `p'.
.TP
.BI ! termserver
the hostname of the terminal server to connect to.
A socket connection will be made to port \fIport\fP (an integer).
.TP
.BI | command
the command to invoke on the console server.
.PP
\fIdevice\fP, !\fItermserver\fP, and |\fIcommand\fP may be followed by
a remote console server name in the form ``\fB@\fP\fIconserver\fP'',
in which case the conserver daemon will send connections for \fIname\fP
to the conserver running on the host named \fIconserver\fP.
When the ``\fB@\fP\fIconserver\fP'' notation is used,
\fBconserver\fP recognizes consoles it should manage locally
by comparing the IP address of \fIconserver\fP
against the IP address of the name returned by gethostname().
Thus, it will recognize host aliases, but not names that map to
different IP addresses that may exist on the same host,
so care must be used in specifying the hostname.
Since \fBconserver\fP does recognize its own hostname,
the same cf file may be used by all servers in a network
if every console line includes a ``\fB@\fP\fIconserver\fP'' specification.
.TP
.I logfile
the full path name of file where all output from
this host is logged.  Any occurrence of `&' will be replaced with
\fIname\fP.  Any path that doesn't begin with a `/' will
have \fIlogdirectory\fP (as specified in the nearest preceding
\fB\s-1LOGDIR=\s0\fP
line) prepended to it.
.TP
.I timestamp-spec
specifies the time between
timestamps applied to the console log file and
whether to log read/write connection actions.
The format of the specification is
[\fImark-interval\fP[\fBm\fP|\fBh\fP|\fBd\fP|\fBl\fP]][\fBa\fP][\fBb\fP].
The timestamps look like `[-- MARK -- Mon Jan 25 14:46:56 1999]'.
The `\fBm\fP', `\fBh\fP', and `\fBd\fP' tags specify
`minutes' (the default), `hours', and `days'.  The `\fBl\fP' tag
specifies `lines' and will cause timestamps of the form
`[Mon Jan 25 14:46:56 PST 1999]' to
be placed every \fImark-interval\fP lines (a newline character signifies
a new line). So, `5h' specifies every five hours and `2l' specifies every
two lines.
An `\fBa\fP' can be specified to add logs of
`attached', `detached', and `bumped' actions,
including the user's name and the host from which the
\fBconsole\fP connection was made,
to the logfile.
A `\fBb\fP' can be specified to add logging of break sequences sent
to the console.
.IP
A default \fItimestamp-spec\fP can be specified by using the
\fB\s-1TIMESTAMP=\s0\fP syntax.
All consoles below the \fB\s-1TIMESTAMP=\s0\fP line will use that
\fItimestamp-spec\fP unless overridden on a per-line basis,
and until superseded by another \fB\s-1TIMESTAMP=\s0\fP line.
To turn off marks for a specific
console, use a \fImark-interval\fP of zero.
.TP
.I break
specifies which break sequence to use.  The default value is `1'.
Values of `0' thru `9' are valid.  A value of `0' will unset the
default break sequence, which will cause the \fB^Ecl0\fP sequence to do
nothing.
.PP
The \fIbreak-spec\fP sequences are defined using
the \fB\s-1BREAK\s0\fIn\fB=\fR
syntax where \fIn\fP is a number from 1 to 9.
There are three builtin defaults: ``\s-1BREAK1\s0=\\z'',
``\s-1BREAK2\s0=\\r~^b'',
and ``\s-1BREAK3\s0=#.reset -x\\r''.  The values of
the \fB\s-1BREAK\s0\fIn\fR
sequences are simple characters strings with the exception of `\\' and
`^':
.sp
.PD 0
.IP \\\\a
alert
.IP \\\\b
backspace
.IP \\\\f
form-feed
.IP \\\\n
newline
.IP \\\\r
carriage-return
.IP \\\\t
tab
.IP \\\\v
vertical-tab
.IP \\\\z
serial break
.IP \\\\\\\\
backslash
.IP \\\\^
circumflex
.IP \\\\\fIooo\fP
octal representation of a character (where \fIooo\fP is one to three
octal digits)
.IP \\\\\fIc\fP
character \fIc\fP
.IP ^?
delete
.IP ^\fIc\fP
control character (\fIc\fP is `and'ed with 0x1f)
.PD
.PP
This section is terminated with a `\fB%%\fP' token on a line by itself.
.PP
The next section of the file contains a list of hosts and addresses
which are allowed to connect to the console server.
.B Conserver
looks for the first match in the config file
for a client's IP address (or network),
or hostname (or domain) if it is able to do a reverse lookup on the IP address,
to determine the level of access to be granted.
Three levels of access may be specified: ``\fBtrust\fP'', ``\fBallow\fP'',
and ``\fBrefuse\fP''.
The access level is followed by a colon and a space-separated list of
addresses or host names.
Any number of any combination of these levels may be specified,
bearing in mind that conserver uses the first match for each incoming
client connection, so order is important.
.PP
Any complete suffix of a host name may be used to define access for all hosts
in that subdomain.
For example, `\fBcc.purdue.edu\fP' will allow `mentor.cc.purdue.edu'
and `mace.cc.purdue.edu', but not `pucc.purdue.edu' or `hack.purdue.edu'.
For IP addresses, optional netmask lengths may be specified
in CIDR `/' notation.
For example, `\fB192.168.1.0\fP' will allow the class C space of 192.168.1.0,
but `\fB192.168.1.0/25\fP' will allow
only the lower half of that same address space (192.168.1.0 thru 192.168.1.127).
.SH EXAMPLE
# name:path:baud:logfile:mark:break
.nf
LOGDIR=/tmp
# overriding the builtin BREAK3 sequence
BREAK3=#.reset\\r
# adding another break sequence
BREAK8=+++
#
# This logs to /tmp/treelog...using BREAK8
tree:/dev/ttyj0:9600e:&log::8
#
# This logs to /tmp/fishlog...
fish:/dev/ttyj1:4800e:fishlog:
#
# Now we're defaulting to /var/tmp for logfiles...
LOGDIR=/var/tmp
#
# So, this is /var/tmp/birdlog with 1-hour timestamps
bird:/dev/ttyj2:4800m:&log:1h
#
# And this is /var/tmp/solarlog, using BREAK4, no timestamps
solar:|telnet solar::solarlog::4
#
# Now things are all in /var/consoles/<console name>
LOGDIR=/var/consoles
shell:|::&:
#
# These open connections to ports 2003 and 2004 of ts1
# using BREAK2 and BREAK3
tribe:!ts1:2003:&::2
# This one also has 10-minute timestamps and activity logging
reptile:!ts1:2004:&:10ma:3
#
# This opens /dev/ttyh0 if running on extra.cc.purdue.edu;
# otherwise, clients are redirected to that host.
mentor:/dev/ttyh0@extra.cc.purdue.edu:2400e:&:
%%
#
# access restrictions
# (note that the "badhost.cc.purdue.edu" entry must appear
# before the "cc.purdue.edu" entry if connections from
# "badhost" are to be rejected, since only the first match
# is used)
#
trusted: console.cc.purdue.edu 128.210.7.90
refuse: badhost.cc.purdue.edu
allow: cc.purdue.edu stat.cc.purdue.edu
.SH "SEE ALSO"
.BR console (1),
.BR conserver.passwd (5),
.BR conserver (8)
