.\" $Id: console.man,v 1.37 2003-10-02 19:00:45-07 bryan Exp $
.TH CONSOLE 1 "2003-10-02" "conserver-8.0.3" "conserver"
.SH NAME
console \- console server client program
.SH SYNOPSIS
.B console
.RB [ \-aAEfFsS ]
.RB [ \-7Dv ]
.RB [ \-c
.IR cred ]
.BR [ \-M
.IR mach ]
.BR [ \-p
.IR port ]
.BR [ \-e
.IR esc ]
.BR [ \-l
.IR user ]
.I console
.br
.B console
.RB [ \-hiIPrRuVwWx ]
.RB [ \-7Dv ]
.RB [ \-M
.IR mach ]
.RB [ \-p
.IR port ]
.RB [ \-d
.RI [ user ][\fB@\fP console ]]
.RB [ \- [ bB ]
.IR message ]
.RB [ \-t
.RI [ user ][\fB@\fP console ]
.IR message ]
.br
.B console
.RB [ \-qQ ]
.RB [ \-7Dv ]
.RB [ \-M
.IR mach ]
.RB [ \-p
.IR port ]
.SH DESCRIPTION
.B Console
is used to manipulate console terminals remotely or to poll running
.BR conserver (8)
daemons for status information.
.PP
In the first form above,
.B console
asks the user's password before
granting interactive access to a console (on a non-trusted system),
since such a session may provide single-user access.
Only as much of the console name as is required to
identify it uniquely to the server is required.
.PP
For non-interactive options,
.B console
outputs only the requested information and exits.
.PP
.B Console
knows only of a primary
.B conserver
host (see the
.B \-M
option below), to which it initially connects.
In a multi-server environment, the primary server may refer
the client to a different server handling the requested console,
or it will provide a list of all servers if required (as when
.B console
is invoked with the
.B \-r
option).
.B Console
then opens connections to the appropriate server(s).
It is not necessary for the user of
.B console
to know which server manages which consoles, as long as
.B console
knows a valid primary server
and all available consoles are listed in the primary server's
configuration file.
.SH OPTIONS
.PP
Options may be given as separate arguments (e.g.,
.B \-v
.BR \-w )
or clustered (e.g.,
.BR \-vw ).
Options and their arguments may be separated by optional white space.
Option arguments containing spaces or other characters special to the shell
must be quoted.
.TP 11
.B \-7
Strip the high bit off of all data received, whether from user
input or from the server, before any processing occurs.
Disallows escape sequence characters with the high bit set.
.TP
.B \-a
Access a console with a two-way (read-write) connection (this is the default).
The connection is dropped to spy mode if someone else is attached read-write.
.TP
.BI \-b message
Broadcast a
.I message
to all users connected to each server.
.TP
.BI \-B message
Same as
.B \-b
but just send a
.I message
to users on the primary server.
.TP
.BI \-c cred
Load an SSL certificate and key from the PEM encoded file
.IR cred .
.TP
.B \-d
Disconnect the users specified by
.IR user @ console .
You may specify the target as
.I user
(disconnect the
.IR user,
regardless of what console they are attached to),
.RI @ console
(disconnect all users attached to
.IR console ),
or
.IR user @ console
(disconnect the
.I user
attached to
.IR console ).
.TP
.B \-D
Enable debugging output.
.TP
.BI \-e esc
Set the initial two-character escape sequence to those represented by
.IR esc .
Any of the forms output by
.BR cat (1)'s
.B \-v
option are accepted.
The default value is
.RB `` ^Ec ''.
.TP
.B \-E
If encryption has been built into the code
.RB ( --with-openssl ),
encrypted client connections are a requirement.
This option allows the client to connect to a console
over a non-encrypted connection.
.TP
.B \-f
Same as
.B \-a
except it will force any existing connection into spy mode.
.TP
.B \-h
Display a brief help message.
.TP
.B \-i
Display information in a machine-parseable format (see below for the details).
.TP
.B \-I
Same as
.B \-i
but just acts on the primary server.
.TP
.BI \-l user
Set the login name used for authentication to
.IR user .
By default,
.B console
uses $USER if its uid matches the user's real uid,
or $LOGNAME if its uid matches the user's real uid,
or else the name associated with the user's real uid.
.TP
.BI \-M mach
The
.B console
client program polls
.I mach
as the primary server,
rather than the default set at compile time (typically
.RB `` console '').
The default
.I mach
may be changed at compile time using the
.B --with-master
option.
.TP
.BI \-p port
Set the port to connect to.
This may be either a port number
or a service name.
The default
.I port
may be changed at compile time
using the
.B --with-port
option.
.TP
.B \-P
Display the pid of the master daemon process on each server.
.TP
.B \-q
The
.B console
client connects to each server to request that the
server daemon quit (shut down).
The root password of the host(s) running conserver is required
unless the local host is listed as ``trusted'' in the
conserver.cf file; in that case, just press <return>.
.TP
.B \-Q
Same as
.B \-q
but just acts on the primary server.
.TP
.B \-r
Display daemon versions.
The
.B console
client connects to each
server to request its version information.
.TP
.B \-R
Same as
.B \-r
but just acts on the primary server.
.TP
.B \-s
Request a read-only (spy mode) connection.
In this mode all the escape sequences (below) work, or report errors,
but all other keyboard input is discarded.
.TP
.B \-t
Send a text
.I message
to
.IR user @ console .
You may specify the target as
.I user
(send to
.IR user,
regardless of what console they are attached to),
.RI @ console
(send to all users attached to
.IR console ),
or
.IR user @ console
(send to
.I user
attached to
.IR console ).
.TP
.B \-u
Show a list of all consoles with status (`up', `down', or `init')
and attached users
.RI ( user @ host
if attached read-write, `<spies>' if only users in spy mode, or `<none>').
.TP
.B \-v
Be more verbose when building the connection(s).
Use this option in combination with any of `show' options (below)
for added benefit.
.TP
.B \-V
Output the version and settings of the console client program
and then exit.
.TP
.B \-w
Show a list of all who are currently connected to consoles,
including the hostnames where the
.B console
connections originate and the idle times.
This is useful to see if anybody is actively
using the console system if it becomes necessary to shut down
.BR conserver .
.TP
.B \-W
Same as
.B \-w
but just acts on the primary server.
.TP
.B \-x
Show a list of consoles and devices.
.PP
The
.BR \-A ,
.BR \-F ", or"
.B \-S
options have the same effect as their lower-case variants.
In addition, they each request the last 20 lines of the console output after
making the connection (as if
.RB ` ^Ecr '
were typed).
.PP
The
.B \-i
option outputs information regarding each console in 13 colon-separated fields.
.TP
.I name
The name of the console.
.TP
.I hostname,pid,socket
The hostname, pid, and socket number of the child process managing
the console.
.TP
.I type
The type of console.
Values will be a `/' for a local device, `|' for
a command, or `!' for a remote port.
.TP
.I console-details
The details regarding the console.
The values here (all comma seperated) depend on the type of the console.
Local devices will have values of the device file, baud rate, and
file descriptor for the device.
Commands will have values of the command, the command's pid, the
pseudo-tty, and file descriptor for the pseudo-tty.
Remote ports will have values of the remote hostname, remote port number,
and file descriptor for the socket connection.
.TP
.I users-list
The details of each user connected to the console.
The details for each
user are an `@' seperated list of `w', `r', or `s' (for read-write, read-only,
or suspended), username, hostname the user is on, the user's idle time,
and (for `r' and `s' users only) ``rw'' or ``ro'' (if the user wants
read-write mode or not).
Each user bundle is seperated by commas.
.TP
.I state
The state of the console.
Values with either be ``up'', ``down'', or ``init''.
.TP
.I perm
This value will either be ``rw'' or ``ro''.
It will only be ``ro'' if
the console is a local device (`/' type) and the permissions are such
that the server can open the file for read, but not write.
.TP
.I logfile-details
The details regarding the logging for the console.
The comma seperated
values will be the logfile, ``log'' or ``nolog'' (if logging is on
or not - toggled via ^EcL), ``act'' or ``noact'' (if activity logging is
enabled or not - the `a' timestamp option), the timestamp interval, and
the file descriptor of the logfile.
.TP
.I break
The default break sequence used for the console.
.TP
.I reup
If the console is currently down and the automatic reconnection code
is at work, it will have the value of ``autoup'', otherwise it
will be ``noautoup''.
.TP
.I aliases
The console aliases are presented in a comma seperated list.
.TP
.I options
The active options for the console are presented in a comma seperated list.
.TP
.I initcmd
The initcmd configuration option for the console.
.SH "ESCAPE SEQUENCES"
The connection can be controlled by a two-character escape sequence, followed
by a command.
The default escape sequence is ``control-E c''
(octal 005 143).
(The escape sequences are actually processed by the server; see the
.BR conserver (8)
man page for more information.)
Commands are:
.sp
.PD 0
.TP 13
.B a
attach read-write if nobody already is
.TP
.B b
send broadcast message to all users on this console
.TP
.B c
toggle flow control (don't do this)
.TP
.B d
down the current console
.TP
.BI e cc
change the escape sequence to the next two characters
.TP
.B f
forcibly attach read-write
.TP
.B g
group info
.TP
.B L
toggle logging on/off
.TP
.B l?
list the break sequences available
.TP
.B l0
send the break sequence associated with this console
.TP
.B l1-9
send the specific break sequence
.TP
.B m
display the "message of the day"
.TP
.B o
close (if open) and reopen the line (to clear errors (silo overflows))
and the log file
.TP
.B p
replay the last 60 lines of output
.TP
.B r
replay the last 20 lines of output
.TP
.B s
switch to spy mode (read-only)
.TP
.B u
show status of hosts/users in this group
.TP
.B v
show the version of the group server
.TP
.B w
who is using this console
.TP
.B x
examine this group's devices and modes
.TP
.B z
suspend this connection
.TP
.B ?
display list of commands
.TP
.BR ^M " (return)"
continue, ignore the escape sequence
.TP
.BR ^R " (ctrl-R)"
replay the last line only
.TP
.BI \e ooo
send character having octal code
.IR ooo " (must"
specify three octal digits)
.IP \.
disconnect
.PD
.PP
If any other character is hit after the escape sequence, all three characters
will be discarded.
Note that a line break or a down command
can only be sent from a full two-way attachment.
To send the escape sequence through the connection one must redefine
the outer escape sequence, or use
.BI ^Ec\e ooo
to send the
first escape character before typing the second character directly.
.PP
In the
.B \-u
output, the login ``<none>'' indicates no one is
viewing that console, and the login ``<spies>'' indicates that
no one has a full two-way attachment.
When no one is attached to
a console its output is cloned to the stdout of the server process if
.B conserver
was started with the
.B \-u
option.
.SH EXAMPLES
.TP 15
console \-u
Outputs something like:
.IP
.ft CR
.nf
dumb      up      <none>
expert    up      ksb@mentor
tyro      up      <spies>
mentor    up      <none>
sage      up      fine@cis
.fi
.ft
.IP
The
.B <none>
indicates no one is viewing
.IR dumb
or
.IR mentor ,
the
.B <spies>
indicates only read-only connections exist for
.IR tyro ,
and other
.IR login @ host
entries indicate users attached read-write to
.I sage
and
.IR expert .
.TP
console \-w
Outputs something like:
.IP
.ft CR
.nf
ksb@extra       attach  2days     expert
file@cis        attach  21:46     sage
dmr@alice       spy     \00:04     tyro
.fi
.ft
.IP
The third column is the idle time of the user.
Either
.IR hours : minutes
or number of days is displayed.
.TP
console \-e "^[1" lv426
Requests a connection to the host ``lv426'' with the escape characters
set to ``escape one''.
.SH BUGS
It is possible to create a loop of console connections, with ugly results.
Never run
.B console
from within a console connection (unless you set each
escape sequence differently).
.PP
The \-i output can produce more than the stated number of fields of
information if the user-provided information has embedded colons.
.PP
I'm sure there are more, I just don't know where they are.
Please let me know if you find any.
.SH AUTHORS
Thomas A. Fine, Ohio State Computer Science
.br
Kevin Braunsdorf, Purdue University Computing Center
.br
Bryan Stansell, conserver.com
.SH "SEE ALSO"
.BR conserver.cf (5),
.BR conserver.passwd (5),
.BR conserver (8)
