.\" $Id: conserver.passwd.man,v 1.10 2004/01/08 16:12:33 bryan Exp $
.TH CONSERVER.PASSWD 5 "2004/01/08" "conserver-8.1.11" "conserver"
.SH NAME
conserver.passwd \- user access information for
.BR conserver (8)
.SH SYNOPSIS
.IB username : password
.SH DESCRIPTION
The
.B conserver.passwd
file is the user authentication and authorization file for
.BR conserver (8).
Upon each incoming client connection,
.B conserver
opens and reads the
.B conserver.passwd
file, so edits to the file take effect immediately.
It reads only until the first
.I username
match.
.PP
Blank lines and comment lines (those beginning with a ``#'' and
optional leading whitespace) are ignored.
Non-ignored lines beginning with whitespace are considered
continuations of the previous line.
This allows you to span one logical line over
many physical lines and insert comments wherever appropriate.
.PP
Each logical line consists of two colon-separated fields.
Leading and trailing white space in each field is ignored.
.TP
.I username
the login name of the authorized user,
or the string
.RB `` *any* ''
to match any user.
This is compared against the name sent by the
.B console
client, based either on the user's identity or on the
.B \-l option.
Since
.B conserver
only uses the first
.I username
match, a
.RB `` *any* ''
entry will apply to any user
without an entry earlier in the file.
.TP
.I password
the encrypted password,
or the string
.RB `` *passwd* ''
to indicate that
.B conserver
should look up the user's password
in the system
.BR passwd " (or " shadow ") database."
If PAM support has been enabled
.RB ( --with-pam ),
PAM lookups will be done instead of
.BR passwd " (or " shadow ") lookups"
(you may need to edit /etc/pam.conf or create /etc/pam.d/conserver).
If this field is empty, password checking is bypassed for this user.
.SH EXAMPLE
.TP 24
.B mary:r71mXjfALB5Ak
Mary uses the password specified above;
it does not matter whether she has a login on the conserver host.
.TP
.B fred:*passwd*
Fred may connect only with his regular login password on the conserver host.
.TP
.B bozo:*
Bozo is only allowed to access a console if his password isn't used (since
it's invalid) which means he needs to come from a
.B trusted
host.
.TP
.B *any*:*passwd*
Anyone not listed above uses their regular login and password.
.SH "SEE ALSO"
.BR console (1),
.BR conserver.cf (5),
.BR conserver (8)
.SH BUGS
.PP
There is currently no way provided by the conserver package
to generate the encrypted password strings
besides copying them from the system
.B passwd
database or running
.BR crypt (3)
via C or perl or some other language that supports it.
