.\" @(#)conserver.8 01/06/91 OSU CIS; Thomas A. Fine
.\" $Id: conserver.man,v 2.3 93/02/09 11:51:56 ldv Exp $
.TH CONSERVER 8L "LOCAL"
.SH NAME
conserver \- console server daemon
.SH SYNOPSIS
.B conserver [\-\fBnv\fP] [\-\fBC\fP \fIconfig\fP]
.br
.B conserver [\-\fBhV\fP]
.SH DESCRIPTION
.B Conserver
is the daemon for the
.IR console (1L)
program.
It provides remote access to the server consoles,
and logs all console data.
Slave hosts which have no current connection might produce important
error messages, these unloved errors are labeled with a machine name
and output on stdout.
.PP
When started, it forks a child for each group in /usr/local/etc/conserver.cf,
and assigns each process a port number to listen on.
The \fIconsole\fP client program knows how to request port numbers and
forwards to find the various slave hosts.
.PP
.B Conserver
completely controls any connection to a controlled host.
All handling of escape sequenes is done by the server,
except the suspend sequence which is
sent as an out-of-band command to the client.
.PP
The
.B conserver
parent process will automatically respawn any child process that dies.
If the parent process receives a SIGTERM, it will propogate the signal
to its children.
.SH OPTIONS
.TP
.BI \-C config
With this option the invoker may specify an alternate confguration.
The default \fIconfig\fP is /usr/local/lib/conserver.cf.
.TP
.B \-h
Output a brief help message.
.TP
.B \-n
The \fIconserver\fP will \fBnot\fP output unloved console output to
stdout.
.TP
.B \-v
Echo the configuration as it is being read (be verbose).
.TP
.B \-V
Output the version of the console server (only) and exit.
.SH EXAMPLES
conserver: expert: login ksb
.br
tyro: panic: my brain hurts
.br
conserver: ksb shifts from expert to tyro
.br
conserver: tyro: logout ksb
.br
\...
.SH FILES
.TS
l l.
/usr/local/lib/conserver.cf	description of console terminal lines
/usr/adm/\fIhost\fP.console	log files for \fIhost\fP's console
/dev/tty??	terminal line device files
\fIstdout\fP	summary of unloved console errors
.TE
.SH AUTHORS
Thomas A. Fine, Ohio State Computer Science
.br
Kevin S Braunsdorf, Purdue University Computing Center
.SH "SEE ALSO"
console(1L), conserver.cf(5L)
