.\" @(#)conserver.8 01/06/91 OSU CIS; Thomas A. Fine
.\" $Id: conserver.man,v 1.4 1999-01-25 18:57:52-08 bryan Exp $
.TH CONSERVER 8L "LOCAL"
.SH NAME
conserver \- console server daemon
.SH SYNOPSIS
.B conserver [\-\fBdnv\fP] [\-\fBC\fP \fIconfig\fP]
.br
.B conserver [\-\fBhV\fP]
.SH DESCRIPTION
.B Conserver
is the daemon for the
.IR console (1L)
program.
It provides remote access to the server consoles,
and logs all console data.
Slave hosts which have no current connection might produce important
error messages; these unloved errors are labeled with a machine name
and output on stdout.
.PP
When started, it forks a child for each group in /etc/conserver.cf and
assigns each process a port number to listen on.  The \fIconsole\fP
client program communicates with the master console server to find
the host and port the child is listening on.
.PP
.B Conserver
completely controls any connection to a controlled host.
All handling of escape sequenes is done by the server,
except the suspend sequence which is
sent as an out-of-band command to the client.
.PP
The
.B conserver
parent process will automatically respawn any child process that dies.
If the parent process receives a SIGTERM, it will propogate the signal
to its children.
.SH OPTIONS
.TP
.BI \-C config
With this option the invoker may specify an alternate confguration.
The default \fIconfig\fP is /usr/local/lib/conserver.cf.
.TP
.B \-d
Become a daemon.
.TP
.B \-h
Output a brief help message.
.TP
.B \-n
The \fIconserver\fP will \fBnot\fP output unloved console output to
stdout.
.TP
.B \-v
Echo the configuration as it is being read (be verbose).
.TP
.B \-V
Output the version of the console server (only) and exit.
.SH FILES
.TS
l l.
/etc/conserver.cf	description of console terminal lines
/etc/conserver.passwd	users allowed to access consoles
\fIstdout\fP	unloved console errors
.TE
.SH AUTHORS
Thomas A. Fine, Ohio State Computer Science
.br
Kevin S Braunsdorf, Purdue University Computing Center
.br
Bryan Stansell, Global Networking and Computing, Inc.
.SH "SEE ALSO"
console(1L), conserver.cf(5L)
