#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include "ntreg.h"
#include "sam.h"
#define MAX_HIVES 10

extern char *val_types[REG_MAX+1];
struct hive *hive[MAX_HIVES+1];
char *tablename="registry";

/* print out sql safe string ptr. We will malloc a new buffer and return that (it may be longer than the buffer we got) */
char *print_sql_data(char *ptr,int length) {
  int i=0;
  int j=0;

  char *result=malloc(length*2);

  for(i=0;i<length;i++) {
 		switch(*(ptr+i)) {
 		case 0:
		  result[j++]='\\';
		  result[j++]='0';
		  break;
 		case '\'':
 		case '\"':
		  result[j++]='\\';
		  result[j++]=*(ptr+i);
		  break;
 		case '\n':
		  result[j++]='\\';
		  result[j++]='n';
		  break;
 		case '\\':
		  result[j++]='\\';
		  result[j++]='\\';
		  break;
 		default:
		  result[j++]=*(ptr+i);
 		};
 	};
  result[j]=0;
  return (result);
};


/* ls -r - list a 'nk' nodes subkeys and values recursively
 * vofs - offset to start of data (skipping block linkage)
 * type - 0 = full, 1 = keys only. 2 = values only
 */
void nk_ls_r(struct hive *hdesc, char *path, int vofs, int type)
{
  struct nk_key *key;
  int nkofs;
  struct ex_data ex;
  struct vex_data vex;
  int count = 0, countri = 0;
  
  nkofs = trav_path(hdesc, vofs, path, 0);

  if(!nkofs) {
    printf("nk_ls: Key <%s> not found\n",path);
    abort();
    return;
  }
  nkofs += 4;

  key = (struct nk_key *)(hdesc->buffer + nkofs);
  //  printf("ls of node at offset 0x%0x\n",nkofs);

  if (key->id != 0x6b6e) {
    printf("Error: Not a 'nk' node!\n");

    //   debugit(hdesc->buffer,hdesc->size);
    
  }
  
  //  printf("Node has %ld subkeys and %ld values\n",key->no_subkeys,key->no_values);
  count = 0;
  if (key->no_values) {
    //    printf("offs        size      type   value name                    [value if type DWORD]\n");
    while ((ex_next_v(hdesc, nkofs, &count, &vex) > 0)) {
      void *data; 
      char *string;
      int i;
      int len=vex.vk->len_data;

      if (vex.vk->len_data & 0x80000000)  {
	len=4;
	data = &(vex.vk->ofs_data);
      } else {
	data = hdesc->buffer + vex.vk->ofs_data +0x1004;
      };

      switch (vex.type) {
      case REG_SZ:
      case REG_EXPAND_SZ:
      case REG_MULTI_SZ:
	string = (char *)malloc(len+10);
	cheap_uni2ascii(data,string,len);
	len=len/2;
	break;
      case REG_DWORD:
	string = (char *)malloc(15);
	snprintf(string,14,"0x%08lx",vex.vk->ofs_data);
	break;
      default:
	string = strdup("Unknown");
	break;
      case REG_BINARY:
	string = (char *)malloc(len+10);
	memcpy(string,data,len);
	//	hexdump((char *)data, 0, len, 1);
	len++;
      }
      //     if (vex.type == REG_DWORD) printf(" %*d [0x%x]",25-strlen(vex.name),vex.val , vex.val);
      {
	char *temp=strdup(path);
	char *clean_name;
	char *clean_value;
	char *clean_path;
	int i;

	//Convert all \ in name to /:
	for(i=0; i<strlen(temp);i++) if(temp[i]=='\\') temp[i]='/';
	
	clean_path=print_sql_data(temp,strlen(temp));
	free(temp);
	clean_name=print_sql_data(vex.name,strlen(vex.name));
	clean_value=print_sql_data(string,len-1);

	printf(" insert into %s set `path`='%s',`size`='%d',`type`='%s',`key`='%s',`value`='%s' ;",tablename,clean_path,vex.size,  (vex.type < REG_MAX ? val_types[vex.type] : "(unknown)"), clean_name,clean_value); 

	free(clean_value);
	free(clean_path);
	free(clean_name);
      };

      printf("\n");
      free(string);
      FREE(vex.name);
    }
  }

  if (key->no_subkeys) {
    //    printf("offs          key name\n");
    while ((ex_next_n(hdesc, nkofs, &count, &countri, &ex) > 0)) {
      //Allocate some memory to append the stings together
      char *new_path=(char *)malloc(strlen(ex.name)+strlen(path)+10);
      strcpy(new_path,path);
      strcat(new_path,"\\");
      strcat(new_path,ex.name);
      //      printf("[%6x]   <%s>\n", ex.nkoffs, new_path);
      nk_ls_r(hdesc,new_path,vofs,type);
      free(new_path);
      FREE(ex.name);
    }
  }

};


void license(void)
{
	printf("flag_reg_read - reads a windows registry hive and generates SQL statements\n\
Type flag_reg_read -h for help.\n\
\n\
Copyright (C) 2003, Michael Cohen (scudette@reapoff.no-ip.com)\n\
\n\
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\
\n\
This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\
\n\
You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA\n\
\n\
Heavily based on chntpw. Here is the Copyright for that:\n\
* Copyright (c) 1997-2002 Petter Nordahl-Hagen.\n\
 * Freely distributable in source or binary for noncommercial purposes,\n\
 * but I allow some exceptions to this.\n\
 * Please see the COPYING file for more details on\n\
 * copyrights & credits.\n\
");
};

/* help: output a helpfull message */
void help(void)
{
	printf("flag_reg_dump - Dumps a windows registry hive into SQL insert statements.\n\
Usage: flag_reg_dump [options]\n\
\n\
-l,--license\t\tPrints out the License terms for this product\n\
-h,--help\t\tThis cruft\n\
-f,--file STR\t\tFilename to open (mandatory)\n\
-t,--table STR\t\tTable name to insert entries into (registry)\n\
");
};

char *filename=NULL;

int main(int argc, char *argv[])
{
  struct hive *hdesc;
  int cdofs, newofs;
  struct nk_key *cdkey;
  char inbuf[100], /* whatbuf[100], */ *bp;
  char path[1000];
  int l, vkofs, nh;
  int usehive = 0;
  int c;
  
  //  char *test=".\0\\";
  // printf("Test string %s-> %s\n",test,print_sql_data(test,3));
  // exit(0);

  //Parse all options
  while (1) {
    int option_index = 0;
    static struct option long_options[] = {
      {"license", 0, 0, 'l'},
      {"help", 0, 0, 'h'},
      {"file", 1, 0, 'f'},
      {"table",1,0,'t'},
      {0, 0, 0, 0}
    };
    
    c = getopt_long(argc, argv,
		    "lhf:t:",
		    long_options, &option_index);
    if (c == -1)
      break;
    
    switch (c) {
    case 'f':
      filename=optarg;
      break;
    case 't':
      tablename=optarg;
      break;
    case 'h':
      help();
      exit(0);
      break;
    case 'l':
      license();
      exit(0);
      break;
    default:
      printf("Unknown option '%c'", c);
      exit(-1);
    }
  }
  if (optind < argc) {
    printf("non-option ARGV-elements: ");
    while (optind < argc)
      printf("%s ", argv[optind++]);
    printf("\n");
     }
  
  if(!filename) {
    help();
    exit(1);
  };
  
  if(!(hdesc = openHive(filename, HMODE_RO) )) {
    printf("Unable to open/read a hive, exiting..\n");
    exit(1);
  };
  cdofs = hdesc->rootofs;
    nk_ls_r(hdesc,"",cdofs+4,0);
  exit(0);

};


/*  Tables must be created first like:
 CREATE TABLE `registry_system` (
`path` CHAR(250) NOT NULL,
`size` SMALLINT NOT NULL,
`type` CHAR(12) NOT NULL,
`key` VARCHAR(200) NOT NULL,
`value` text
)
*/
