#!/bin/sh

#
# Script to substitute @XXX@ with given values
#

subst=w

while [ $# -gt 2 ] ; do
    macro=`echo "$1" | sed 's/=.*//'`
    value=`echo "$1" | sed -e 's/^[^=]*=[ 	]*//' -e 's/[ 	]*$//'`
    if [ X"$macro" = X"$1" ]; then
	echo "$0: substitution argument has no =: $1" 1>&2
	exit 1
    fi
    shift
    subst="1,\$g=@$macro@=s=@$macro@=$value=
${subst}"
done

if [ $# != 2 ] ; then
    echo "$0: too few arguments" 1>&2
    echo "Usage: $0 foo=bar [...] src-file dst-file" 1>&2
    exit 1
fi

if [ X"$subst" = Xw ] ; then
    echo "$0: no substitutions specified" 1>&2
    echo "Usage: $0 foo=bar [...] src-file dst-file" 1>&2
    exit 1
fi

src=$1
dst=$2
tmp=/tmp/do_subst.$$
ecode=1

trap 'rm -f $tmp 2> /dev/null; trap '' 0; exit $ecode' 0 1 2 3

cp $src $tmp || {
    echo "$0: can't copy $src to $tmp" 1>&2
    exit 1
}

ed - $tmp << EOF
${subst}
EOF

if [ $? != 0 ] ; then
    echo "$0: error editing $src (ed failed)" 1>&2
    exit 1
fi

cp $tmp $dst || {
    echo "$0: can't copy $tmp to $dst" 1>&2
    exit 1
}

ecode=0
