#!/bin/sh

#
# Silly script to work around pod2html
#

USAGE="Usage: $0 dest-html-dir file [...]"

tdir=/tmp/html$$
trap "rm -r $tdir; trap - 0; exit 1" 0 1 2 3 13 15

mkdir $tdir || {
    echo "$0: can't make $tdir" 1>&2
    exit 1
}

if [ $# -lt 2 ]; then
    echo "$0: too few arguments" 1>&2
    echo "$USAGE" 1>&2
    exit 1
fi

dest=$1
shift

if [ ! -d "$dest" ] ; then
    echo "$0: $dest is not a directory" 1>&2
    echo "$USAGE" 1>&2
    exit 1
fi

files=
for i
do
    case $i in
      *.pl|*.pm|*.pod)
	;;
      *)
	echo "$0: bad file argument (must be .pm, .pl or .pod): $i" 2>&1
	exit 1
    esac
    f=`echo $i | sed -e 's/\.pl$//' -e 's/\.pod$//' -e 's/\.pm//'`
    files="$files $f"
    cp $i $tdir/$f.pm || {
	echo "$0: can't copy $i to $tdir/$f.pm" 1>&2
	exit 1
    }
done

for i in $files; do
    pod2html --podpath=. --noindex --podroot=$tdir < $tdir/$i.pm | sed -e 's:/\./::g' -e 's/html#"/html"/g' > $tdir/$i.html || {
	echo "$0: can't create html for $i" 1>&2
	exit 1
    }
    cp "$tdir/$i.html" "$dest/$i.html" || {
	echo "$0: can't copy $tdir/$i.html to $dest/$f.html" 1>&2
	exit 1
    }
done
rm -f pod2html-dircache pod2html-itemcache
