#!/usr/bin/perl -w
#*****************************************************
# Copyright 2003: Commonwealth of Australia.
#
# Developed by the Computer Network Vulnerability Team,
# Information Security Group.
# Department of Defence.
# Dr. Michael Cohen
# David Collett
# Julian Tehan
# Matthew Byrne
# Gavin Jackson
#******************************************************

# executes reports
use DBI;
use CGI qw/:standard -oldstyle_urls/;
use strict;
use Data::Dumper;
use POSIX ":sys_wait_h";
use strict;

#Redirect errors to the browser so i can see whats wrong
#open(STDERR,">&STDOUT");

#prototypes
sub process_request($$);

#Global database handle for the analysis database (not the master db).
my $dbh;
my $co=new CGI;
my $r=shift;

my %parameters=$co->Vars;

$parameters{"apache_obj"}=$r;

#Loads all the reports from here.
use reports;

#Did the user specify a report? If not - show them the menu.
my $report=Report::new(\%parameters);
if(!exists($parameters{'report'})) {
  $report->show(\%parameters);
  exit;
};

$dbh=$report->{"DBH"};
process_request(\%parameters,$report);
$co->DESTROY;
exit();

sub process_request($$) {
  my $reference = shift;
  my $report=shift;
  my %parameters=%{$reference};
  my $pid;

  my $result = $report->process_report($parameters{"report"},\%parameters);
  
  #Maximum size of report 1meg
  if(length($result)>1000000) {
    $result = substr($result,0,100000)."\n<p><h1>Report truncated<h1>";
  };

  my $co=new CGI;
  print $co->header.$result;
  $report->DESTROY;
  $co->DESTROY;
  exit();
};

