#!/usr/bin/perl -w
# ******************************************************
# Copyright 2003: Commonwealth of Australia.
#
# Developed by the Computer Network Vulnerability Team,
# Information Security Group.
# Department of Defence.
# ******************************************************
#   Version: FLAG 0.3 (08-07-2003)
# ******************************************************
#
# * This program is free software; you can redistribute it and/or
# * modify it under the terms of the GNU General Public License
# * as published by the Free Software Foundation; either version 2
# * of the License, or (at your option) any later version.
# *
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU General Public License for more details.
# *
# * You should have received a copy of the GNU General Public License
# * along with this program; if not, write to the Free Software
# * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
##################################################################

use strict;
use CGI;
use HTTP::Daemon;
use IO::Handle;
use HTTP::Headers;
use HTTP::Status;
use DBI;
use Data::Dumper;
use POSIX ":sys_wait_h";

#Allowes us to override the exit call
#use subs qw(exit);

#sub exit {
#  return;
#}

#This is used to debug display,progress and framework. Debugging messages are found in the debug_framework file
my $debug_framework=1;

#If we need to debug - we throw all debugging information into a file:
if ($debug_framework) {
  close(STDERR);
  open(STDERR,">>debug_framework") || die("Cant open debug file");
  print STDERR "\nFlag Debug output ". time."\n-------------------------------------------\n";
}


#Constants
my $IMAGE_PATH="images/";

#prototypes
sub process_request($$);

#Reaper subroutine - indescrimnately kill zombies!!!!:
local  $SIG{CHLD} = sub {
  while (waitpid(-1,WNOHANG)>0){};
};


#Global database handle for the analysis database (not the master db).
my $dbh;
my $co;

use reports;

my $HTTP_server = HTTP::Daemon->new(LocalAddr => "127.0.0.1",LocalPort => 8080,ReuseAddr=>1) || die;

print "My URL is: ".$HTTP_server->url."\n";
while (1) {
  my $HTTP_client = $HTTP_server->accept || next;
  my $r=$HTTP_client->get_request;
  
  my $pid=fork();
  #Process the request in the child
  if ($pid) {
    #Wait for the child to finish... is this needed?
  } else {
    if ($r) {
      #This is used to redirect STDOUT into the socket (just like apache).
      my $fd=fileno($HTTP_client);
      open(STDOUTBU,">&STDOUT");
#      print STDOUTBU "Just served a request\n".Data::Dumper->Dump([$r]);
      open(STDOUT,">&=$fd") or die("Problem redirecting stdout $@");
      
      my @url;
      if ($r->method eq "GET") {
	@url =split "\\\?",$r->uri;
      } else {
	@url =("flag",$r->content);
      }
      
      if ($url[0]=~/images\/([^\/]*)/) {
	#They asked for an image - so we just give it to them:
	my $image=$1;
	#Images are only allowed in the correct directory:
	$image=~s/\///g;
	if (sysopen(HANDLE,$IMAGE_PATH.$image,0)) {
	  $HTTP_client->send_basic_header(200);
	  my $co=new CGI;
	  print $co->header(-type=>"image/png");
	  print join "",<HANDLE>;
	  close(HANDLE);
	} else {
	  $HTTP_client->send_basic_header(403);
	}
      } else {
	$HTTP_server->url =~ /http:\/\/([^:]*):([^\/]*)/;
	
	#print STDOUTBU "my request url = ".$url[-1];
	$ENV{'REQUEST_URI'}=$r->uri;
	$ENV{'SCRIPT_NAME'}="/flag";
	$ENV{'REQUEST_METHOD'}='GET';
	$ENV{'QUERY_STRING'} = $url[-1];
	$ENV{'SERVER_NAME'}=$1;
	$ENV{'SERVER_PORT'}=$2;
	
	my $co=new CGI($url[-1]);
	
	print STDOUTBU "my url = ".$co->self_url."\n\n";
	my %parameters=$co->Vars;
	#Did the user specify a report? If not - show them the menu.
	my $report=Report::new(\%parameters,\$co);
	
	if(!exists($parameters{'report'})) {
	  $HTTP_client->send_basic_header(200);
	  print $co->header;
	  print $report->show(\%parameters);
	} else { 
	  $dbh=$report->{"DBH"};
	  $HTTP_client->send_basic_header(200);
	  process_request(\%parameters,$report);
	};
	
	$report->DESTROY;
	$co->DESTROY;
      };
      #restore saved STDOUT...
      close(STDOUT);
      open(STDOUT,">&STDOUTBU");
      
      $r->DESTROY;
    };
    CORE::exit(0);
  };
  
  
  $HTTP_client->close;
  undef($HTTP_client);
};



sub process_request($$) {
  my $reference = shift;
  my $report=shift;
  my %parameters=%{$reference};
  my $pid;

  my $result = $report->process_report($parameters{"report"},\%parameters);
  
  #Maximum size of report 1meg
  if(length($result)>1000000) {
    $result = substr($result,0,100000)."\n<p><h1>Report truncated<h1>";
  };

  my $co=new CGI;
  print $co->header.$result;
  $report->DESTROY;
  $co->DESTROY;
};
