/*
** The Sleuth Kit
**
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003 Brian Carrier.  All rights reserved
**
*/

#ifndef _DOS_H
#define _DOS_H

typedef struct {
    u_int8_t boot;
    u_int8_t start_chs[3];
    u_int8_t ptype;
    u_int8_t end_chs[3];
    u_int8_t start_sec[4];
    u_int8_t size_sec[4];
} dos_part;

/* Boot Sector w/partition table */
typedef struct {
    u_int8_t filler[446];
    dos_part ptable[4];
    u_int8_t magic[2];
} dos_sect;

#define DOS_MAGIC	0xaa55
#define DOS_PART_OFFSET 0

#endif
