/*
** The Sleuth Kit
**
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003 Brian Carrier.  All rights reserved
**
*/

#ifndef _MAC_H
#define _MAC_H

typedef struct {
    u_int8_t magic[2];
    u_int8_t reserved[2];
	u_int8_t pmap_size[4];
	u_int8_t start_sec[4];
	u_int8_t size_sec[4];
	u_int8_t name[32];
	u_int8_t type[32];
	u_int8_t data_start_sec[4];
	u_int8_t data_size_sec[4];
	u_int8_t status[4];
	u_int8_t boot_start_sec[4];
	u_int8_t boot_size_sec[4];
	u_int8_t boot_load_addr[4];
	u_int8_t reserved2[4];
	u_int8_t boot_entry[4];
	u_int8_t reserved3[4];
	u_int8_t boot_checksum[4];
	u_int8_t proc_type[16];
	u_int8_t reserved4[376];
} mac_part;

#define MAC_MAGIC	0x504d
#define MAC_PART_OFFSET	1

#endif
