/*
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2003 Brian Carrier.  All rights reserved
 *
 * mm_types - set the type value given a string of partition type
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * mmtools is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with mactime; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, LOSS OF USE, DATA, OR PROFITS OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include "mm_tools.h"


typedef struct {
    char    *name;
    char code;
    char    *comment;
} MM_TYPES;


MM_TYPES mm_open_table[] = {
    {"dos", MM_DOS, "DOS-based partitions [Windows, Linux, etc.]"},
    {"mac", MM_MAC, "MAC partitions"},
    {"bsd", MM_BSD, "BSD Disklabels [FreeBSD, OpenBSD, NetBSD]"},
    {"sun", MM_SUN, "Sun Volume Table of Contents (Solaris)"},
    {0},
};

/* parse the string and return the value */
char 
mm_parse_type(const char *str)
{

	MM_TYPES *types;

	for (types = mm_open_table; types->name; types++) {
		if (strcmp(str, types->name) == 0) {
			return types->code;
		}
	}

	return MM_UNSUPP;
}

void
mm_print_types()
{
	MM_TYPES *types;
	for (types = mm_open_table; types->name; types++)
		printf("\t%s (%s)\n", types->name, types->comment);
}
