/*
 * The Sleuth Kit
 *
 * Brian Carrier [carrier@sleuthkit.org]
 * Copyright (c) 2004 Brian Carrier.  All rights reserved
 *
 * This file is part of mmtools
 *
 * mmtools is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 */

#ifndef _GPT_H
#define _GPT_H


/* Partition type in the safety DOS partition table */
#define GPT_PART_OFFSET	0
#define GPT_DOS_TYPE	0xEE



/* This is located in sector 1 of the disk */
#define GPT_HEAD_OFFSET	1
#define GPT_HEAD_SIG	0x5452415020494645ULL

typedef struct {
	u_int8_t	signature[8];	/* EFI PART */
	u_int8_t	version[4];
	u_int8_t	head_size_b[4];	/* size of partition header */
	u_int8_t	head_crc[4];	/* crc of header */
	u_int8_t	f1[4];		
	u_int8_t	head_lba[8];	/* lba of this header */
	u_int8_t	head2_lba[8];	/* lba of second header */
	u_int8_t	partarea_start[8]; /* lba of partition area start */
	u_int8_t	partarea_end[8]; /* lba of partition area end */
	u_int8_t	guid[16];	/* disk GUID */
	u_int8_t	tab_start_lba[8];	/* lba of table start */
	u_int8_t	tab_num_ent[4]; 	/* num of table entries */
	u_int8_t	tab_size_b[4];	/* size of each table entry */
	u_int8_t	tab_crc[4]; 	/* crc of table */
	u_int8_t	f2[420];
} gpt_head;


/* The location of this is specified in the header - tab_start */
typedef struct {
	u_int8_t	type_guid[16];	/* partition type guid */
	u_int8_t	id_guid[16];	/* unique partition GUID */
	u_int8_t	start_lba[8];	/* Starting lba of part */
	u_int8_t	end_lba[8];	/* end lba of part */
	u_int8_t	flags[8];	/* flags */
	u_int8_t	name[72];	/* name in unicode */
} gpt_entry;




#endif
