/*
** ffind  (file find)
** The Sleuth Kit 
**
** $Date: 2005/03/15 21:17:21 $
**
** Find the file that uses the specified inode (including deleted files)
** 
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003-2005 Brian Carrier.  All rights reserved 
**
** TASK
** Copyright (c) 2002 Brian Carrier, @stake Inc.  All rights reserved
**
**
** TCTUTILs
** Brian Carrier [carrier@cerias.purdue.edu]
** Copyright (c) 2001 Brian Carrier.  All rights reserved
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**
** 1. Redistributions of source code must retain the above copyright notice,
**    this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.     
**
**
** THIS SOFTWARE IS NOT AFFILIATED WITH PURDUE UNIVERSITY OR THE CENTER FOR
** EDUCATION IN INFORMATION ASSURANCE AND SECURITY (CERIAS) AND THEY BEAR
** NO RESPONSIBILITY FOR ITS USE OR MISUSE.
**
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
**
** IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
** INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
** (INCLUDING, BUT NOT LIMITED TO, LOSS OF USE, DATA, OR PROFITS OR
** BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
** OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*/
#include "fs_tools.h"
#include "fs_lib.h"
#include "error.h"

/* NTFS has an optimized version of this function */
extern void ntfs_find_file(FS_INFO *, INUM_T, uint32_t, uint32_t, int,
			   FS_DENT_WALK_FN, char *);



static INUM_T inode = 0;
static uint8_t localflags = 0;
static uint8_t found = 0;

static uint8_t
find_file_act(FS_INFO * fs, FS_DENT * fs_dent, int flags, void *ptr)
{
    /* We found it! */
    if (fs_dent->inode == inode) {
	found = 1;
	if (flags & FS_FLAG_NAME_UNALLOC)
	    printf("* ");

	printf("/%s%s\n", fs_dent->path, fs_dent->name);

	if (!(localflags & FFIND_ALL)) {
	    return WALK_STOP;
	}
    }
    return WALK_CONT;
}


uint8_t
fs_ffind(FS_INFO * fs, uint8_t lclflags, INUM_T inode_a, uint32_t type,
	 uint32_t id, int flags)
{

    found = 0;
    localflags = lclflags;
    inode = inode_a;

    /* Since we start the walk on the root inode, then this will not show
     ** up in the above functions, so do it now
     */
    if (inode == fs->root_inum) {
	if (flags & FS_FLAG_NAME_ALLOC) {
	    printf("/\n");
	    found = 1;

	    if (!(lclflags & FFIND_ALL))
		return 0;
	}
    }

    if ((fs->ftype & FSMASK) == NTFS_TYPE) {
	ntfs_find_file(fs, inode, type, id, flags, find_file_act, NULL);
    }
    else {
	fs->dent_walk(fs, fs->root_inum, flags, find_file_act, NULL);
    }

    if (found == 0) {

	/* With FAT, we can at least give the name of the file and call
	 * it orphan 
	 */
	if ((fs->ftype & FSMASK) == FATFS_TYPE) {
	    FS_INODE *fs_inode = fs->inode_lookup(fs, inode);
	    if (fs_inode->name != NULL) {
		if (fs_inode->flags & FS_FLAG_NAME_UNALLOC)
		    printf("* ");
		printf("%s/%s\n", ORPHAN_STR, fs_inode->name->name);
	    }
	}
	else {
	    printf("inode not currently used\n");
	}
    }

    return 0;
}
