/*
** dstat
** The Sleuth Kit 
**
** $Date: 2005/03/25 03:12:34 $
**
** Get the details about a data unit
**
** Brian Carrier [carrier@sleuthkit.org]
** Copyright (c) 2003-2005 Brian Carrier.  All rights reserved 
**
** TASK
** Copyright (c) 2002 Brian Carrier, @stake Inc.  All rights reserved
**
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**
** 1. Redistributions of source code must retain the above copyright notice,
**    this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. The name of the author may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
**
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
** WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
** MERCHANTABILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
**
** IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
** INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
** (INCLUDING, BUT NOT LIMITED TO, LOSS OF USE, DATA, OR PROFITS OR
** BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
** OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
** ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*/
#include "fs_lib.h"

#include "ffs.h"
#include "ext2fs.h"
#include "fatfs.h"


static uint8_t
dstat_act(FS_INFO * fs, DADDR_T addr, char *buf, int flags, void *ptr)
{
    switch (fs->ftype & FSMASK) {
    case EXTxFS_TYPE:
	printf("Block: %" PRIuDADDR "\n", addr);
	break;
    case FFS_TYPE:
	printf("Fragment: %" PRIuDADDR "\n", addr);
	break;
    case FATFS_TYPE:
	printf("Sector: %" PRIuDADDR "\n", addr);
	break;
    case NTFS_TYPE:
	printf("Cluster: %" PRIuDADDR "\n", addr);
	break;
    default:
	printf("Unsupported File System\n");
	exit(1);
    }

    printf("%sAllocated%s\n", (flags & FS_FLAG_DATA_ALLOC) ? "" : "Not ",
	   (flags & FS_FLAG_DATA_META) ? " (Meta)" : "");

    if ((fs->ftype & FSMASK) == FFS_TYPE) {
	FFS_INFO *ffs = (FFS_INFO *) fs;
	printf("Group: %lu\n", (ULONG) ffs->cg_num);
    }
    else if ((fs->ftype & FSMASK) == EXTxFS_TYPE) {
	EXT2FS_INFO *ext2fs = (EXT2FS_INFO *) fs;
	if (addr >= ext2fs->first_data_block)
	    printf("Group: %lu\n", (ULONG) ext2fs->grpnum);
    }
    else if ((fs->ftype & FSMASK) == FATFS_TYPE) {
	FATFS_INFO *fatfs = (FATFS_INFO *) fs;
	/* Does this have a cluster address? */
	if (addr >= fatfs->firstclustsect) {
	    printf("Cluster: %lu\n",
		   (ULONG) (2 +
			    (addr -
			     fatfs->firstclustsect) / fatfs->csize));
	}
    }

    return WALK_STOP;
}



uint8_t
fs_dstat(FS_INFO * fs, uint8_t lclflags, DADDR_T addr, int flags)
{
    fs->block_walk(fs, addr, addr, flags, dstat_act, "dstat");
    return 0;
}
