#!/bin/sh
#
# Corrects for system specific issues
#

SYSTEM=`uname -s 2> /dev/null`;
RELEASE=`uname -r 2> /dev/null`;

#DEFS="-D_LIBEWF_DEBUG_";

case "$SYSTEM" in

	FreeBSD*)
		DEFS="$DEFS -DBSD";
		;;
	NetBSD*)
		DEFS="$DEFS -DBSD";
		;;
	OpenBSD*)
		DEFS="$DEFS -DBSD";
		;;
	BSD/OS*)
		DEFS="$DEFS -DBSD";
		;;
	SunOS*)
		DEFS="$DEFS -DSUNOS";
		;;
	Linux*)
		DEFS="$DEFS -DLINUX";
		;;
	Darwin*)
		DEFS="$DEFS -DDARWIN";
		;;
   CYGWIN_NT-*)
		DEFS="$DEFS -DCYGWIN"
		;;
        Inter*)
		DEFS="$DEFS -DINTERNIX";
		;;
             *)
		echo "Unsupported system: $SYSTEM.$RELEASE" 1>&2;
		exit 1;
		;;
esac

make DEFS="$DEFS" $1

