/*
 * CRC error
 *
 * Copyright (c) 2006, Joachim Metz <forensics@hoffmannbv.nl>,
 * Hoffmann Investigations. All rights reserved.
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name of the creator, related organisations, nor the names of
 *   its contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * - All advertising materials mentioning features or use of this software
 *   must acknowledge the contribution by people stated in the acknowledgements.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER, COMPANY AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "libewf_common.h"

#include <stdlib.h>

#include "libewf_endian.h"
#include "libewf_notify.h"

#include "ewf_crc.h"
#include "libewf_crc_error.h"

/* Allocates memory for a buffer of CRC error sectors 
 * Returns a pointer to the new instance, NULL on error
 */
LIBEWF_CRC_ERROR_SECTOR *libewf_crc_error_alloc( uint32_t amount )
{
	LIBEWF_CRC_ERROR_SECTOR *sectors = NULL;
	uint32_t size                    = 0;

	size    = amount * LIBEWF_CRC_ERROR_SECTOR_SIZE;
	sectors = (LIBEWF_CRC_ERROR_SECTOR *) libewf_common_alloc_cleared( size, 0 );

	if( sectors == NULL )
	{
		LIBEWF_WARNING_PRINT( "libewf_crc_error_alloc: unable to allocate sectors.\n" );

		return( NULL );
	}
	return( sectors );
}

/* Reallocates memory for a buffer of CRC error sectors 
 * Returns a pointer to the instance, NULL on error
 */
LIBEWF_CRC_ERROR_SECTOR *libewf_crc_error_realloc( LIBEWF_CRC_ERROR_SECTOR *sectors, uint32_t previous_amount, uint32_t new_amount )
{
	uint32_t previous_size = previous_amount * LIBEWF_CRC_ERROR_SECTOR_SIZE;
	uint32_t new_size      = new_amount * LIBEWF_CRC_ERROR_SECTOR_SIZE;

	if( sectors == NULL )
	{
		LIBEWF_WARNING_PRINT( "libewf_crc_error_realloc: invalid sectors.\n" );

		return( NULL );
	}
	sectors = (LIBEWF_CRC_ERROR_SECTOR *) libewf_common_realloc_new_cleared( sectors, previous_size, new_size, 0 );

	if( sectors == NULL )
	{
		LIBEWF_WARNING_PRINT( "libewf_crc_error_realloc: unable to reallocate sectors.\n" );

		return( NULL );
	}
	return( sectors );
}

/* Frees memory of a buffer of CRC error sectors
 */
void libewf_crc_error_free( LIBEWF_CRC_ERROR_SECTOR *sectors )
{
	if( sectors == NULL )
	{
		LIBEWF_WARNING_PRINT( "libewf_crc_error_free: invalid sectors.\n" );

		return;
	}
	libewf_common_free( sectors );
}

