/*
 * libewf file writing
 *
 * Copyright (c) 2006, Joachim Metz <forensics@hoffmannbv.nl>,
 * Hoffmann Investigations. All rights reserved.
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name of the creator, related organisations, nor the names of
 *   its contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 * - All advertising materials mentioning features or use of this software
 *   must acknowledge the contribution by people stated in the acknowledgements.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER, COMPANY AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LIBEWF_FILE_WRITE_H
#define _LIBEWF_FILE_WRITE_H

#include "ewf_header.h"
#include "libewf_header_values.h"
#include "libewf_handle.h"

#ifdef __cplusplus
extern "C" {
#endif

int8_t libewf_write_create_headers( LIBEWF_HANDLE *handle, LIBEWF_HEADER_VALUES *header_values );

LIBEWF_HANDLE *libewf_write_set_parameters( LIBEWF_HANDLE *handle, uint64_t input_file_size, uint32_t sectors_per_chunk, uint32_t bytes_per_sector, uint32_t error_granularity_sectors, uint64_t ewf_file_size, int8_t compression_level, uint8_t format, uint8_t read_error_retry, uint8_t wipe_block_on_read_error, uint8_t compress_empty_block );
LIBEWF_HANDLE *libewf_write_set_header_values( LIBEWF_HANDLE *handle, LIBEWF_HEADER_VALUES *header_values );

int32_t libewf_write_maximum_segment_files( LIBEWF_HANDLE *handle );
int8_t libewf_write_determine_segment_file_extension( LIBEWF_HANDLE *handle, char* extension, uint32_t segment );
char *libewf_write_create_segment_filename( LIBEWF_HANDLE *handle, char* basename, uint32_t segment );
int8_t libewf_write_create_segment_file( LIBEWF_HANDLE *handle, uint32_t segment );

int32_t libewf_write_headers( LIBEWF_HANDLE *handle, int file_descriptor, uint32_t start_offset );
int32_t libewf_write_segment_file_start( LIBEWF_HANDLE *handle, int file_descriptor, uint32_t segment );
int32_t libewf_write_segment_file_chunks_section_start( LIBEWF_HANDLE *handle, int file_descriptor, uint32_t segment_file_offset, uint32_t chunk_amount, uint8_t section_number, EWF_TABLE_OFFSET *offsets );
int32_t libewf_write_segment_file_chunks_section_correction( LIBEWF_HANDLE *handle, int file_descriptor, uint32_t segment_file_offset, uint32_t chunk_amount, uint8_t section_number, EWF_TABLE_OFFSET *offsets, uint32_t chunks_section_offset, uint32_t chunks_section_size );
int32_t libewf_write_segment_file_end( LIBEWF_HANDLE *handle, int file_descriptor, uint32_t segment_file_offset, uint8_t last_segment_file );

int64_t libewf_write_from_file_descriptor( LIBEWF_HANDLE *handle, int input_file_descriptor, uint64_t write_size, uint64_t write_offset, void (*callback)( uint64_t bytes_read, uint64_t bytes_total ) );

#ifdef __cplusplus
}
#endif

#endif

